CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, org)
            values
                (new.id_emp, nextval('sq_ct'), ifthen(_bx_ct.tp_bx = 'R', 'R', 'P'), _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto);
                     
        end if;
        
        select nome into _descr_part
        from tb_part
        where
            id_part = _bx_ct.id_part;
            
        if (_descr_part is null) then
            _descr_part := '';
        else
            _descr_part := ' ' || _descr_part;
        end if;
        
        _descr := ifthen(_bx_ct.tp_bx = 'R', 'RECEBIMENTO', 'PAGAMENTO');
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, _bx_ct.id_bx_ct,
                 _bx_ct.id_part, 'PEND');
        else
            perform fc_gera_mov_fnc(new.id_emp, _bx_ct.id_cx, _bx_ct.id_usr, _bx_ct.dt_bx, cast(current_time as time), trim(_descr || _descr_part),
                ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_bx_ct);
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_log (
)
RETURNS trigger AS
$body$
declare
    _pk varchar[];
    _val varchar[];
    _col_list varchar[];
    _val_list varchar[];
    _id_est integer;
    _i integer;
    _idx integer;
    _count integer;
    _aux varchar;
begin
    select
        array(
            select 
                cast(c.column_name as varchar)
            from information_schema.table_constraints tc
            join information_schema.constraint_column_usage as ccu using 
                (constraint_schema, constraint_name)
            join information_schema.columns as c on 
                (c.table_schema = tc.constraint_schema and 
                 tc.table_name = c.table_name and 
                 ccu.column_name = c.column_name)
            where 
                constraint_type = 'PRIMARY KEY' and
                tc.table_name = tg_table_name
            )
    into _pk;
    
    select
        array(
            select 
                pg_attribute.attname
            from pg_attribute 
            join pg_class on 
                (pg_attribute.attrelid = pg_class.oid) 
            where 
                pg_attribute.attname not in ('oid', 'tableoid', 'cmax', 'xmax', 'cmin', 'xmin', 'ctid') and 
                pg_class.relname = tg_table_name
            order by
                pg_attribute.attnum
        )
    into _col_list;
    
    
    _id_est := fc_id_est_con();
    
    _count := array_upper(_pk, 1);
    
    for _i in 1.._count loop

        if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using new;
        else
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using old;
        end if;
        
        -- raise notice '% %', _pk[_i], _aux;
        
        _val[_i] := _aux;
    end loop;
    
    
    insert into tb_log
        (id_log, org, op, col_pk, val_pk, id_est, dt_hr)
    values
        (nextval('sq_log'), tg_table_name, substring(tg_op, 1, 1), _pk, _val, _id_est, CURRENT_TIMESTAMP);
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

