-- ALTER TABLE public.tb_nf_item
--  DROP CONSTRAINT fk__nf_item__ncm RESTRICT;

-- ALTER TABLE public.tb_nf
--  DROP CONSTRAINT fk__nf__vnd RESTRICT;

-- ALTER TABLE public.tb_item
--   DROP CONSTRAINT fk__item__ncm RESTRICT;

CREATE OR REPLACE FUNCTION public.fc_tr_mnt_estq_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _lst_mnt_estq_item refcursor;
    _mnt_estq_item record;
    _op varchar;
BEGIN
    if (lower(old.op) <> 'i') then
    
        _op := ifthen(lower(old.op) = 't', 'e', lower(old.op));

        open _lst_mnt_estq_item for
            select *
            from tb_mnt_estq_item
            where
                id_emp = old.id_emp and
                id_mnt_estq = old.id_mnt_estq;
        
        fetch _lst_mnt_estq_item into _mnt_estq_item;
        
        while found loop
        
            perform fc_item_estq(_mnt_estq_item.id_item, _mnt_estq_item.id_emp, old.id_dep_dst, _mnt_estq_item.id_grd_estq, _op, _mnt_estq_item.vl_qtd_mov);
            
            if (old.id_dep_org is not null) then
                perform fc_item_estq(_mnt_estq_item.id_item, _mnt_estq_item.id_emp, old.id_dep_org, _mnt_estq_item.id_grd_estq, 'e', _mnt_estq_item.vl_qtd_mov);
            end if;
        
            fetch _lst_mnt_estq_item into _mnt_estq_item;
            
        end loop;
        
    end if;
    
    return old;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_mnt_estq_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _mnt_estq record;
    _mnt_estq_item record;
    _op varchar;
    _upd_op varchar;
BEGIN
    
    select * into _mnt_estq 
    from tb_mnt_estq
    where
        tb_mnt_estq.id_emp = new.id_emp and
        tb_mnt_estq.id_mnt_estq = new.id_mnt_estq;

    if (lower(_mnt_estq.op) <> 'i') then
    
        _op := ifthen(lower(_mnt_estq.op) = 't', 'e', lower(_mnt_estq.op));


        if (tg_op = 'UPDATE') then
            
            _upd_op := ifthen(lower(_op) = 'e', 's', 'e');
            

            perform fc_item_estq(old.id_item, old.id_emp, _mnt_estq.id_dep_dst, old.id_grd_estq, _upd_op, old.vl_qtd_mov);
            
            if (_mnt_estq.id_dep_org is not null) then
                perform fc_item_estq(old.id_item, old.id_emp, _mnt_estq.id_dep_org, old.id_grd_estq, _op, old.vl_qtd_mov);
            end if;
            
        end if;

        
        perform fc_item_estq(new.id_item, new.id_emp, _mnt_estq.id_dep_dst, new.id_grd_estq, _op, new.vl_qtd_mov);
            
        if (_mnt_estq.id_dep_org is not null) then
            perform fc_item_estq(new.id_item, new.id_emp, _mnt_estq.id_dep_org, new.id_grd_estq, 's', new.vl_qtd_mov);
        end if;
        
    end if;
    
    return new;
    
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

