CREATE OR REPLACE FUNCTION public.fc_restart_sequence (
)
RETURNS boolean AS
$body$
declare
    v_cur refcursor;
    v_rec record;
    v_op varchar;
    v_id_max integer;
    v_aux integer;
    v_sql varchar;
begin

    select count(*) into v_aux
    from tb_est;
    
    if (v_aux > 1) then
        raise exception 'Existe mais de uma estação cadastrada, execute a funcao de iniciar estação';
        return false;
    end if;

 
    open v_cur for
        select relname, substring(relname, 4, length(relname)) as "entidade"
        from pg_class
        where 
            relname like 'sq_%';
     
    fetch v_cur into v_rec;
     
    while found loop
     
        select count(*) into v_aux
        from pg_class
        where
            relname = 'tb_' || v_rec."entidade";
         
        if (v_aux > 0) then
            v_sql := 'select max("id_' || v_rec."entidade" || '")::integer ' ||
                'from "tb_' || v_rec."entidade" || '"';
            if (v_rec.entidade = 'tb_cmp_cst') then
                v_sql := v_sql + ' where id_cmp_cst < 1000';
            end if;
                
                
            execute v_sql into v_id_max;
         
            raise notice '[% %]   ', v_rec."relname", v_id_max;
             
            if (v_id_max is not null) then
                execute 'alter sequence "' || v_rec."relname" || '" restart with ' || v_id_max + 1;
            else
                execute 'alter sequence "' || v_rec."relname" || '" restart with 1';
            end if;
        end if;
         
        fetch v_cur into v_rec;
    end loop;
     
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_mdfe_dest_xml (
  id_emp INTEGER NOT NULL, 
  id_mdfe_dest INTEGER NOT NULL, 
  xml TEXT, 
  id_usr_ult_alt INTEGER, 
  CONSTRAINT pk_mdfe_dest_xml PRIMARY KEY(id_emp, id_mdfe_dest)
) ;

ALTER TABLE public.tb_mdfe_dest_xml
  ADD CONSTRAINT fk__mdfe_dest_xml__mdfe_dest FOREIGN KEY (id_emp, id_mdfe_dest)
    REFERENCES public.tb_mdfe_dest(id_emp, id_mdfe_dest)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;
