DROP TRIGGER tr_mov_fnc_af ON public.tb_mov_fnc;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_mov_fnc_bf (
)
RETURNS trigger AS
$body$
declare
    _item record;
begin

    if (coalesce(new.org, '') <> '') then
    
        select * into _item
        from tb_mov_fnc
        where
            id_emp = new.id_emp and
            id_mov_cx = new.id_mov_cx and
            op = new.op and
            org = new.org
        limit 1;
            
        if (found) then
            
            raise exception 'Duplicidade de lancamento financeiro';
            
            return null;
            
        end if;
    end if;

    return new;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_mov_fnc_af (
)
RETURNS trigger AS
$body$
declare
    _mov_cx record;
begin
    if ((tg_op = 'UPDATE') and (old.op = 'T')) or (tg_op = 'DELETE') then
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'MOV_FNC.' || old.id_mov_fnc;
                
        delete from tb_mov_bnc
        where
            id_emp = old.id_emp and
            org = 'MOV_FNC.' || old.id_mov_fnc;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        if (new.op = 'T') and (new.dst = 'C') and (coalesce(new.id_dst, 0) > 0) then
            insert into tb_mov_fnc
                (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc, 
                 doc, descr, op, vl_lanc, 
                 org, id_org, id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_fnc'), new.id_dst, new.id_usr, new.dt_lanc, new.hr_lanc,
                 new.doc, new.descr, 'C', new.vl_lanc, 'MOV_FNC.' || new.id_mov_fnc, new.id_mov_fnc, new.id_op_fnc);
        end if;
        
        if (new.op = 'T') and (new.dst = 'M') and (coalesce(new.id_dst, 0) > 0) then
            
            select * into _mov_cx
            from tb_mov_cx 
            where
                id_emp = new.id_emp and
                id_mov_cx = new.id_dst;
                
            insert into tb_mov_fnc
                (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc, 
                 doc, descr, op, vl_lanc, 
                 org, id_org, id_op_fnc,
                 id_mov_cx)
            values
                (new.id_emp, nextval('sq_mov_fnc'), _mov_cx.id_cx, new.id_usr, new.dt_lanc, new.hr_lanc,
                 new.doc, new.descr, 'C', new.vl_lanc, 'MOV_FNC.' || new.id_mov_fnc, new.id_mov_fnc, new.id_op_fnc,
                 new.id_dst);
        end if;
        
        if (new.op = 'T') and (new.dst = 'B') and (coalesce(new.id_dst, 0) > 0) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc,
                 nr_doc, descr, op, vl_lanc, conc,
                 org, id_org,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_dst, new.dt_lanc, new.dt_lanc, 
                 new.doc, new.descr, 'C', new.vl_lanc, false, 
                 'MOV_FNC.' || new.id_mov_fnc, new.id_mov_fnc,
                 new.id_usr_ult_alt, new.dt_hr_ult_alt,
                 new.id_op_fnc);
        end if;
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TRIGGER tr_mov_fnc_af
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_mov_fnc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_mov_fnc_af();

-- !!! The object has a circular dependency. Script correction required

CREATE TRIGGER tr_mov_fnc_bf
  BEFORE INSERT 
  ON public.tb_mov_fnc FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_mov_fnc_bf();

