CREATE SEQUENCE public.sq_contr_frete
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE SEQUENCE public.sq_tp_contr_frete
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE TABLE public.tb_tp_contr_frete (
  id_tp_contr_frete INTEGER NOT NULL, 
  descr VARCHAR(150), 
  conf VARCHAR(255), 
  vl_aliq_ss NUMERIC(12,2), 
  vl_aliq_taxa_coop NUMERIC(12,2), 
  vl_aliq_comis1 NUMERIC(12,2), 
  vl_aliq_comis_coop NUMERIC(12,2), 
  CONSTRAINT pk_tp_contr_frete PRIMARY KEY(id_tp_contr_frete)
) ;

CREATE TABLE public.tb_contr_frete (
  id_emp INTEGER NOT NULL, 
  id_contr_frete INTEGER NOT NULL, 
  id_tp_contr_frete INTEGER, 
  num INTEGER, 
  id_cte INTEGER, 
  dt_emis DATE, 
  vl_trf NUMERIC(12,2), 
  vl_frete NUMERIC(12,2), 
  vl_aliq_inss NUMERIC(12,2), 
  vl_inss NUMERIC(12,2), 
  vl_aliq_irrf NUMERIC(12,2), 
  vl_irrf NUMERIC(12,2), 
  vl_aliq_ss NUMERIC(12,2), 
  vl_ss NUMERIC(12,2), 
  vl_aliq_taxa_coop NUMERIC(12,2), 
  vl_taxa_coop NUMERIC(12,2), 
  vl_dif_frete NUMERIC(12,2), 
  vl_aliq_comis1 NUMERIC(12,2), 
  vl_comis1 NUMERIC(12,2), 
  vl_seg NUMERIC(12,2), 
  vl_aliq_comis_coop NUMERIC(12,2), 
  vl_comis_coop NUMERIC(12,2), 
  vl_issqn NUMERIC(12,2), 
  vl_adto NUMERIC(12,2), 
  vl_tot NUMERIC(12,2), 
  obs VARCHAR(255), 
  id_part INTEGER, 
  sit VARCHAR(1), 
  CONSTRAINT pk_contr_frete PRIMARY KEY(id_emp, id_contr_frete)
) ;

ALTER TABLE public.tb_cte
  ADD COLUMN vl_carga_averb NUMERIC(12,2);

ALTER TABLE public.tb_cte
  ADD COLUMN vl_trf NUMERIC(12,4);

ALTER TABLE public.tb_cte
  ADD COLUMN vl_bc NUMERIC(12,4);

ALTER TABLE public.tb_contr_frete
  ADD CONSTRAINT fk__contr_frete__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_contr_frete
  ADD CONSTRAINT fk__contr_frete__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_contr_frete
  ADD CONSTRAINT fk__contr_frete__tp_contr_frete FOREIGN KEY (id_tp_contr_frete)
    REFERENCES public.tb_tp_contr_frete(id_tp_contr_frete)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

