CREATE SEQUENCE public.sq_pdc_colab
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_pdc_colab_item_bf (
)
RETURNS trigger AS
$body$
BEGIN
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 's', old.vl_qtd);
    end if;
        
        
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'e', new.vl_qtd);
    end if;
    
    return new;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_pdc_colab_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
BEGIN
    select * into _op_fnc
    from tb_op_fnc
    where
        tp_op_fnc = 'DUP'
    limit 1;
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'PDC_COLAB.' || old.id_pdc_colab;
            
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        _id_ct := nextval('sq_ct');
    
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             org, id_op_fnc, vl_quit, vl_rest, 
             id_plano_ct,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_ult_alt, dt_hr_ult_alt)
        values
            (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, new.id_colab, new.id_pdc_colab, 1, 1,
             new.dt_pdc_colab, new.dt_venc, new.vl_tot, 'P', 
             'PDC_COLAB.' || new.id_pdc_colab, _op_fnc.id_op_fnc, 0, new.vl_tot, 
             new.id_plano_ct,
             new.vl_tot, 0, 0, 0, 0, 
             new.id_usr_ult_alt, new.dt_hr_ult_alt);
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_pdc_colab (
  id_emp INTEGER NOT NULL, 
  id_pdc_colab INTEGER NOT NULL, 
  id_colab INTEGER, 
  dt_pdc_colab DATE, 
  dt_venc DATE, 
  id_plano_ct VARCHAR(100), 
  vl_tot NUMERIC(12,2), 
  obs TEXT, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_pdc_colab PRIMARY KEY(id_emp, id_pdc_colab)
) ;

CREATE TRIGGER tr_pdc_colab_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_pdc_colab FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_pdc_colab_bf();

CREATE TABLE public.tb_pdc_colab_item (
  id_emp INTEGER, 
  id_pdc_colab INTEGER, 
  id_pdc_colab_item INTEGER, 
  id_item INTEGER, 
  vl_qtd NUMERIC(12,4), 
  vl_unt NUMERIC(12,4), 
  vl_tot NUMERIC(12,4), 
  id_grd_estq VARCHAR(20), 
  id_dep INTEGER, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER
) ;

CREATE TRIGGER tr_pdc_colab_item_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_pdc_colab_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_pdc_colab_item_bf();

ALTER TABLE public.tb_pdc_colab_item
  ADD CONSTRAINT fk__pdc_colab_item__dep FOREIGN KEY (id_emp, id_dep)
    REFERENCES public.tb_dep(id_emp, id_dep)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc_colab_item
  ADD CONSTRAINT fk__pdc_colab_item__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc_colab_item
  ADD CONSTRAINT fk__pdc_colab_item__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc_colab_item
  ADD CONSTRAINT fk__pdc_colab_item__pdc_colab FOREIGN KEY (id_emp, id_pdc_colab)
    REFERENCES public.tb_pdc_colab(id_emp, id_pdc_colab)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc_colab
  ADD CONSTRAINT fk__pdc_colab__colab FOREIGN KEY (id_colab)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc_colab
  ADD CONSTRAINT fk__pdc_colab__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_pdc_colab
  ADD CONSTRAINT fk__pdc_colab__plano_ct FOREIGN KEY (id_plano_ct)
    REFERENCES public.tb_plano_ct(id_plano_ct)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;
