CREATE SEQUENCE public.sq_ct_ctb
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE SEQUENCE public.sq_fact
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE SEQUENCE public.sq_mov_ctb
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_fact_item_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _fact record;
    _nr_doc varchar;
    _app_con varchar;
    _id_ct integer;
begin
    _app_con := fc_app_con();
    
    
    if (_app_con <> 'NEO_UNI') then
    
        if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            delete from tb_ct
            where 
                id_emp = old.id_emp and
                org = 'FACT.' || old.id_fact || '.' || old.id_fact_item;
        end if;
        
        if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            select * into _fact
            from tb_fact
            where
                id_emp = new.id_emp and
                id_fact = new.id_fact;
                
                    
            if (_op_fnc.gera_ct) then
                    
                _nr_doc := new.nr_ch;
                    
                if (_op_fnc.tp_op_fnc = 'DUP' and coalesce(_nr_doc, '') = '') then
                    _nr_doc := new.id_fact || '/' || new.id_fact_item;
                end if;
                
                _id_ct := nextval('sq_ct');
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                     org, id_op_fnc, vl_quit, vl_rest, 
                     id_plano_ct,
                     vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                     id_usr_ult_alt, dt_hr_ult_alt)
                values
                    (new.id_emp, _id_ct, 'R', _op_fnc.tp_op_fnc, _fact.id_cli, _nr_doc, new.id_fact_item, 0,
                     _fact.dt_fact, new.dt_venc, new.vl_doc, 'P', 
                     new.nome_emit_ch, new.cpf_cnpj_emit_ch, new.id_bnc_ch, new.ag_ch, new.cnt_ch, null,
                     'FACT.' || new.id_fact || '.' || new.id_fact_item, new.id_op_fnc, 0, new.vl_doc, 
                     null,
                     new.vl_doc, 0, 0, 0, 0, 
                     _fact.id_usr_ult_alt, _fact.dt_hr_ult_alt);
                
            end if;

        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_mov_ctb (
  id_emp INTEGER, 
  id_mov_ctb INTEGER, 
  id_ct_ctb_d INTEGER, 
  id_ct_ctb_c INTEGER, 
  dt_op DATE, 
  descr VARCHAR(255), 
  vl_op NUMERIC(12,2), 
  org VARCHAR(50), 
  id_org VARCHAR(20), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER
) ;

CREATE INDEX pk_mov_ctb ON public.tb_mov_ctb
  USING btree (id_emp, id_mov_ctb);

CREATE TABLE public.tb_fact (
  id_emp INTEGER NOT NULL, 
  id_fact INTEGER NOT NULL, 
  id_cli INTEGER, 
  vl_tot NUMERIC(12,2), 
  vl_jur NUMERIC(12,2), 
  vl_liq NUMERIC(12,2), 
  obs TEXT, 
  dt_fact DATE, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_fact PRIMARY KEY(id_emp, id_fact)
) ;

CREATE TABLE public.tb_fact_item (
  id_emp INTEGER NOT NULL, 
  id_fact INTEGER NOT NULL, 
  id_fact_item INTEGER NOT NULL, 
  id_op_fnc INTEGER, 
  dt_i DATE, 
  vl_perc_jur NUMERIC(12,2), 
  dt_venc DATE, 
  qtd_dias INTEGER, 
  vl_doc NUMERIC(12,2), 
  vl_jur NUMERIC(12,2), 
  vl_liq NUMERIC(12,2), 
  nr_ch VARCHAR(20), 
  ag_ch VARCHAR(20), 
  cnt_ch VARCHAR(20), 
  id_bnc_ch VARCHAR(3), 
  cpf_cnpj_emit_ch VARCHAR(20), 
  nome_emit_ch VARCHAR(150), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  CONSTRAINT pk_fact_item PRIMARY KEY(id_emp, id_fact, id_fact_item)
) ;

CREATE TRIGGER tr_fact_item_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_fact_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_fact_item_bf();

ALTER TABLE public.tb_mov_ctb
  ADD CONSTRAINT fk__mov_ctb__ct_ctb_c FOREIGN KEY (id_ct_ctb_c)
    REFERENCES public.tb_ct_ctb(id_ct_ctb)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_ctb
  ADD CONSTRAINT fk__mov_ctb__ct_ctb_d FOREIGN KEY (id_ct_ctb_d)
    REFERENCES public.tb_ct_ctb(id_ct_ctb)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_mov_ctb
  ADD CONSTRAINT fk__mov_ctb__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_fact_item
  ADD CONSTRAINT fk__fact_item__bnc FOREIGN KEY (id_bnc_ch)
    REFERENCES public.tb_bnc(id_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_fact_item
  ADD CONSTRAINT fk__fact_item__fact FOREIGN KEY (id_emp, id_fact)
    REFERENCES public.tb_fact(id_emp, id_fact)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_fact_item
  ADD CONSTRAINT fk__fact_item__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_fact
  ADD CONSTRAINT fk__fact__cli FOREIGN KEY (id_cli)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_fact
  ADD CONSTRAINT fk__fact__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;


















select fc_add_col('public.' || pg_tables.tablename, 'id_usr_ult_alt', 'integer')
from pg_tables
where
    pg_tables.schemaname = 'public';


select fc_add_col('public.' || pg_tables.tablename, 'dt_hr_ult_alt', 'timestamp')
from pg_tables
where
    pg_tables.schemaname = 'public';


select fc_add_col('public.' || pg_tables.tablename, 'id_usr_cad', 'integer')
from pg_tables
where
    pg_tables.schemaname = 'public';


    
select fc_add_col('public.' || pg_tables.tablename, 'dt_hr_cad', 'timestamp')
from pg_tables
where
    pg_tables.schemaname = 'public';


select fc_add_col('public.' || pg_tables.tablename, 'id_est_ult_alt', 'integer')
from pg_tables
where
    pg_tables.schemaname = 'public';

select fc_add_col('public.' || pg_tables.tablename, 'id_est_cad', 'integer')
from pg_tables
where
    pg_tables.schemaname = 'public';