CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct__ct_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        
        update tb_ct set
            stat = case when new.vl_rest = 0 then 'Q' else 'P' end,
            vl_quit = vl_quit + new.vl_quit,
            vl_rest = new.vl_rest,
            id_plano_ct = coalesce(new.id_plano_ct, id_plano_ct),
            dt_hr_ult_alt = new.dt_hr_ult_alt,
            id_usr_ult_alt = new.id_usr_ult_alt,
            id_est_ult_alt = new.id_est_ult_alt
        where
            id_emp = new.id_emp_ct and
            id_ct = new.id_ct;
            
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        
        update tb_ct set
            stat = 'P',
            vl_quit = vl_quit - old.vl_quit,
            vl_rest = vl_rest + old.vl_quit - old.vl_acr,
            dt_hr_ult_alt = new.dt_hr_ult_alt,
            id_usr_ult_alt = new.id_usr_ult_alt,
            id_est_ult_alt = new.id_est_ult_alt
        where
            id_emp = old.id_emp_ct and
            id_ct = old.id_ct;
            
    end if;
    
    return null;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;


alter table tb_carreg add column hr_i time;