SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_aju_bx_ct (
  _dt date
)
RETURNS boolean AS
$body$
declare
    _id_est_local integer;
begin
    
    _id_est_local := fc_id_est_local();

    update tb_ct set
        vl_quit = (select sum(tb_bx_ct__ct1.vl_quit)
                   from tb_bx_ct__ct as tb_bx_ct__ct1
                   where
                       tb_bx_ct__ct1.id_emp_ct = tb_ct.id_emp and
                       tb_bx_ct__ct1.id_ct = tb_ct.id_ct)
    from tb_bx_ct
    join tb_bx_ct__ct on
        (tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp and
         tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct)
    where
        mod(tb_bx_ct.id_bx_ct, 100) = _id_est_local and
        cast(tb_bx_ct.dt_hr_ult_alt as date) >= _dt and
        tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp and
        tb_bx_ct__ct.id_ct = tb_ct.id_ct;
        
    update tb_ct set
        vl_rest = tb_ct.vl_ct - coalesce(tb_ct.vl_quit, 0)
    from tb_bx_ct
    join tb_bx_ct__ct on
        (tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp and
         tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct)
    where
        mod(tb_bx_ct.id_bx_ct, 100) = _id_est_local and
        cast(tb_bx_ct.dt_hr_ult_alt as date) >= _dt and
        tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp and
        tb_bx_ct__ct.id_ct = tb_ct.id_ct;

    update tb_ct set
         stat = 'Q'
    from tb_bx_ct
    join tb_bx_ct__ct on
        (tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp and
         tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct)
    where
        mod(tb_bx_ct.id_bx_ct, 100) = _id_est_local and
        cast(tb_bx_ct.dt_hr_ult_alt as date) >= _dt and
        tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp and
        tb_bx_ct__ct.id_ct = tb_ct.id_ct and
        tb_ct.vl_rest <= 0 and
        tb_ct.stat <> 'Q';
        
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

