
do $$ 
declare
    _list refcursor;
    _item record;
    _sq_value integer;
	_count integer;
begin
    select count(*) into _count from tb_est;
    
    if (_count = 0) then
        insert into tb_est
            (id_est, descr, seq_inc, "local", tp_est, sit, def_cust)
        values
            (nextval('sq_est'), 'CENTRAL', 1, true, 'C', 'A', false);
    end if;

    select 100 + fc_id_est_local() into _sq_value;
            
    execute 'alter sequence sq_item_hist_cst restart with ' || cast(_sq_value as varchar);
    execute 'alter sequence sq_item_hist_vnd restart with ' || cast(_sq_value as varchar);
    
    if (fc_id_est_local() = fc_id_est_central()) then
    
        update tb_item_hist_cst set
            id_item_hist_cst = null;

        update tb_item_hist_vnd set
            id_item_hist_vnd = null;

        
        open _list for
            select *
            from tb_item_hist_cst;
        
        fetch _list into _item;
        
        while found loop
            update tb_item_hist_cst set
                id_item_hist_cst = nextval('sq_item_hist_cst')
            where
                current of _list;
        
            fetch _list into _item;
        end loop;
            
        close _list;
        
        
        open _list for
            select *
            from tb_item_hist_vnd;
        
        fetch _list into _item;
        
        while found loop
            update tb_item_hist_vnd set
                id_item_hist_vnd = nextval('sq_item_hist_vnd')
            where
                current of _list;
        
            fetch _list into _item;
        end loop;
        
    else
    
        truncate table tb_item_hist_cst;
        truncate table tb_item_hist_vnd;
        
    end if;
end $$;