CREATE OR REPLACE FUNCTION public.fc_gera_mov_fnc (
  _tb_org varchar,
  _id_emp integer,
  _id_org integer
)
RETURNS boolean AS
$body$
declare
    _org_list refcursor;
    _org record;
begin

    if (_tb_org = 'tb_vnd') then
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'VND.' || _id_org || '%';
    
        open _org_list for
            select
                tb_vnd.id_cx as id_cx,
                tb_vnd.id_usr as id_usr,
                tb_vnd.id_vnd as id_org,
                tb_vnd.dt_vnd as dt_lanc,
                'VENDA ' || coalesce(tb_vnd.nome, '') || as descr,
                'C' as op,
                sum(tb_vnd_parc.vl_parc) as vl_lanc,
                'VND.' || tb_vnd.id_vnd || '.' || tb_op_fnc.id_op_fnc as org,
                tb_op_fnc.id_op_fnc,
                tb_vnd.id_vnd as doc
            from tb_vnd
            join tb_vnd_parc on
                (tb_vnd.id_emp = tb_vnd_parc.id_emp and
                 tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
            join tb_op_fnc on
                (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_vnd.id_emp = _id_emp and
                tb_vnd.id_vnd = _id_org
            group by
                tb_vnd.id_cx,
                tb_vnd.id_vnd,
                tb_vnd.id_usr,
                tb_vnd.dt_vnd,
                tb_vnd.nome,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr;
                
    elsif (_tb_org = 'tb_bx_ct') then
    
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'BX.' || _id_org || '%';
    
        open _org_list for
            select
                tb_bx_ct.id_cx as id_cx,
                tb_bx_ct.id_usr as id_usr,
                tb_bx_ct.id_bx_ct as id_org,
                tb_bx_ct.dt_bx as dt_lanc,
                ifthen(tb_bx_ct.tp_bx = 'R', 'RECEBIMENTO ', 'PAGAMENTO ') || coalesce(tb_part.nome, '') as descr,
                ifthen(tb_bx_ct.tp_bx = 'R', 'C', 'D') as op,
                sum(tb_bx_ct_pagto.vl_pagto) as vl_lanc,
                'BX.' || tb_bx_ct.id_bx_ct || '.' || tb_op_fnc.id_op_fnc as org,
                tb_op_fnc.id_op_fnc,
                tb_bx_ct.id_bx_ct as doc
            from tb_bx_ct
            join tb_bx_ct_pagto on
                (tb_bx_ct.id_emp = tb_bx_ct_pagto.id_emp and
                 tb_bx_ct.id_bx_ct = tb_bx_ct_pagto.id_bx_ct)
            left outer join tb_part on
                (tb_bx_ct.id_part = tb_part.id_part)
            join tb_op_fnc on
                (tb_bx_ct_pagto.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_bx_ct.id_emp = _id_emp and
                tb_bx_ct.id_bx_ct = _id_org
            group by
                tb_bx_ct.id_cx,
                tb_bx_ct.id_bx_ct,
                tb_bx_ct.tp_bx,
                tb_bx_ct.id_usr,
                tb_bx_ct.dt_bx,
                tb_part.nome,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr;
    
    elsif (_tb_org = 'tb_nf') then
    
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'NF.' || _id_org || '%';
    
        open _org_list for
            select
                tb_nf.id_cx as id_cx,
                tb_nf.id_usr as id_usr,
                tb_nf.id_nf as id_org,
                tb_nf.dt_op as dt_lanc,
                'NF ' || coalesce(tb_nf.fant_emt, '') as descr,
                'D' as op,
                sum(tb_nf_parc.vl_parc) as vl_lanc,
                'NF.' || tb_nf.id_nf || '.' || tb_op_fnc.id_op_fnc as org,
                tb_op_fnc.id_op_fnc,
                tb_nf.num as doc
            from tb_nf
            join tb_nf_parc on
                (tb_nf.id_emp = tb_nf_parc.id_emp and
                 tb_nf.id_nf = tb_nf_parc.id_nf)
            join tb_op_fnc on
                (tb_nf_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_nf.id_emp = _id_emp and
                tb_nf.id_nf = _id_org and
                tb_nf.tp_emis = '[T]'
            group by
                tb_nf.id_cx,
                tb_nf.id_nf,
                tb_nf.id_usr,
                tb_nf.dt_op,
                tb_nf.num,
                tb_nf.fant_emt,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr;
    
    end if;

    fetch _org_list into _org;
    
    while found loop
    
        insert into tb_mov_fnc
            (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc,
             descr, op, vl_lanc, org, id_org, id_op_fnc, doc)
        values
            (_id_emp, nextval('sq_mov_fnc'), _org.id_cx, _org.id_usr, _org.dt_lanc, substring(cast(current_time as varchar), 1, 8)::time, 
             _org.descr, _org.op, _org.vl_lanc, _org.org, _org.id_org, _org.id_op_fnc, _org.doc);
    
        fetch _org_list into _org;
        
    end loop;


    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
begin
    _app_con := fc_app_con();
    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        if (new.vl_rest > 0) then
            select * into _op_fnc
            from tb_op_fnc
            where
                tp_op_fnc = 'DUP'
            order by
                id_op_fnc
            limit 1;
            
            insert into tb_ct
                (id_emp, id_ct, tp_ct, id_part, parc, qtd_parc, 
                 dt_emis, dt_venc,
                 vl_ct, obs, stat, tp_doc, 
                 org, id_op_fnc)
            values
                (new.id_emp, nextval('sq_ct'), new.tp_bx, new.id_part, 1, 1,
                new.dt_bx, new.dt_bx,
                new.vl_rest, 'RESTANTE BAIXA ' || new.id_bx_ct, 'P', 'DUP',
                'BX.' || new.id_bx_ct, _op_fnc.id_op_fnc);
        end if;
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
    
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct;
            
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'BX.' || _id_org || '%';
            
    end if;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;    
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
        /*
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;*/
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, org, id_op_fnc)
            values
                (new.id_emp, nextval('sq_ct'), ifthen(_bx_ct.tp_bx = 'R', 'R', 'P'), _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_op_fnc);
                     
        end if;
        
        select nome into _descr_part
        from tb_part
        where
            id_part = _bx_ct.id_part;
            
        if (_descr_part is null) then
            _descr_part := '';
        else
            _descr_part := ' ' || _descr_part;
        end if;
        
        _descr := ifthen(_bx_ct.tp_bx = 'R', 'RECEBIMENTO', 'PAGAMENTO');
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, _bx_ct.id_bx_ct,
                 _bx_ct.id_part, 'PEND');
        /*
        else
            
            perform fc_gera_mov_fnc(new.id_emp, _bx_ct.id_cx, _bx_ct.id_usr, _bx_ct.dt_bx, cast(current_time as time), trim(_descr || _descr_part),
                ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_bx_ct, new.id_op_fnc);
                */
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_bf (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _nf_item_list refcursor;
    _nf_item record;
    _op_inv varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (tg_op in ('INSERT', 'UPDATE') ) and (_app_con <> 'NEO_UNI') then
        if (tg_op  = 'INSERT' and new.tp_emis = '[P]' and new.num is null) then
            new.num := fc_get_num_nf(new.id_emp, new.ser);
        end if;
    
        return new;
    elsif (tg_op = 'DELETE') then
    
        if (old.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
        
        open _nf_item_list for
            select *
            from tb_nf_item
            where
                id_emp = old.id_emp and
                id_nf = old.id_nf;
    
        fetch _nf_item_list into _nf_item;
        
        
    
        while found loop
            if (_nf_item.mov_estq) then
                perform fc_item_estq(_nf_item.id_item, _nf_item.id_emp, _nf_item.id_dep, _nf_item.id_grd_estq, _op_inv, _nf_item.vl_qtd_mov);
            end if;
            
            fetch _nf_item_list into _nf_item;
        end loop;
        
        close _nf_item_list;
        
        
        if (_app_con <> 'NEO_UNI') then
            delete from tb_mov_fnc
            where
                id_emp = old.id_emp and
                org like 'NF.' || old.id_nf || '%';
        end if;
 
        
    
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
    _app_con varchar;
begin
    _app_con := fc_app_con();

    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
        
   end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, 
                     id_cnt_bnc, org,
                     obs, id_op_fnc)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, _nf.id_part_emt, new.nr_doc, new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                     new.id_cnt_bnc, 'NF.' || new.id_nf || '.' || new.id_nf_parc,
                     'NF ' || _nf.num || ' ' || _op_fnc.descr, new.id_op_fnc);
                     
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC') then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _nf.dt_op, new.dt_venc, new.nr_doc, 'D', new.vl_parc, 'NF ' || _nf.num || ' ' || _op_fnc.descr, false,
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, _nf.id_nf,
                     _nf.id_part_emt, 'PEND');
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _id_cli_cons varchar;
begin
    _app_con := fc_app_con();

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
    
        if (new.org = 'CONSIG') then
            update tb_consig set
                sit = 'F'
            where
                id_emp = new.id_emp and
                id_consig = new.id_org;
        end if;
        
        _id_cli_cons := fc_get_emp_cnf(new.id_emp, 01000);
        
        if (cast(new.id_cli as varchar) <> _id_cli_cons) then
            
            update tb_part set
                id_cond_pagto = new.id_cond_pagto,
                id_fm_pagto = new.id_fm_pagto
            where
                id_part = new.id_cli;
                
        end if;
            
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        
        if (old.org = 'CONSIG') then
            update tb_consig set
                sit = 'D'
            where
                id_emp = old.id_emp and
                id_consig = old.id_org;
        end if;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org like 'VND.' || old.id_vnd || '%';
    
    end if;
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
    _app_con varchar;
begin
    _app_con := fc_app_con();
    
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        
        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        select * into _vnd
        from tb_vnd
        where
            id_emp = new.id_emp and
            id_vnd = new.id_vnd;

        if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
            _nr_doc := new.nr_doc;
                
            if (_op_fnc.tp_op_fnc = 'DUP') then
                _nr_doc := new.id_vnd || '/' || new.nr_parc;
            end if;
            
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                 org, id_op_fnc)
            values
                (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                 _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
                 'VND.' || new.id_vnd || '.' || new.id_vnd_parc, new.id_op_fnc);
        end if;
            
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                 'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd,
                 _vnd.id_cli, 'PEND');
        end if;
    end if;

    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

DROP FUNCTION public.fc_gera_mov_fnc(_id_emp integer, _id_cx integer, _id_usr integer, _dt_lanc date, _hr_lanc time, _descr varchar, _op varchar, _vl_lanc numeric, _org varchar, _id_org integer, _id_op_fnc integer);

