CREATE OR REPLACE FUNCTION public."fc_restart_sequence" (
)
returns boolean as
$body$
declare
    v_cur refcursor;
    v_rec record;
    v_op varchar;
    v_id_max integer;
    v_aux integer;
begin
 
    open v_cur for
        select relname, substring(relname, 4, length(relname)) as "entidade"
        from pg_class
        where 
            relname like 'sq_%';
     
    fetch v_cur into v_rec;
     
    while found loop
     
        select count(*) into v_aux
        from pg_class
        where
            relname = 'tb_' || v_rec."entidade";
         
        if (v_aux > 0) then
            execute 'select max("id_' || v_rec."entidade" || '")::integer ' ||
                'from "tb_' || v_rec."entidade" || '"' into v_id_max;
         
            raise notice '[% %]   ', v_rec."relname", v_id_max;
             
            if (v_id_max is not null) then
                execute 'alter sequence "' || v_rec."relname" || '" restart with ' || v_id_max + 1;
            else
                execute 'alter sequence "' || v_rec."relname" || '" restart with 1';
            end if;
        end if;
         
        fetch v_cur into v_rec;
    end loop;
     
    return true;
end;
$body$
language 'plpgsql'
volatile
called on null input
security invoker
cost 100;