CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _aux varchar[];
    _qtd integer;
    _contr record;
    _dt_venc date;
    
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    
    _op_fnc record;  
    _tp_ct varchar;
    _id_ct integer;
    
    _app_con varchar;
    _nr_doc integer;
    
    _vl_quit numeric;
    _vl_rest numeric;
    _exc_ct_dest boolean;
    _ger_ct_dest boolean;
    _ct_alt boolean;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and (new.tp_doc = 'CH' or new.tp_doc = 'CH_PRZ')) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, tp_org, id_org, 
                 id_part,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, 'CT', new.id_ct, 
                 new.id_part,
                 new.id_op_fnc);
        end if;

        
    elsif (tg_op = 'DELETE') then
        if (old.fat) then
            update tb_ct set
                stat = 'P',
                id_fat = null
            where
                id_fat = old.id_ct;
        end if;
        
        if (coalesce(old.id_fat, 0) > 0) then
            raise exception 'Esta conta esta vinculada a uma fatura e nao pode ser excluida';
            return null;
        end if;
        
        
        if (old.tp_ct = 'R') and (old.org = 'MOV_COLAB.ADTO') and (_app_con <> 'NEO_UNI') then
        
            delete from tb_recibo
            where
                id_emp = old.id_emp and
                org = 'MOV_COLAB.ADTO.' || old.id_ct;
                
        end if;
                

        if (old.tp_ct = 'P') and (_app_con <> 'NEO_UNI') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
                
            if (coalesce(old.org, '') like 'BX_MOV_FUNC.%') then
                _aux := regexp_split_to_array(old.org, '\.');
                
                update tb_mov_func set
                    id_bx_mov_func = null,
                    sit = 'P'
                where
                    id_emp = old.id_emp and
                    id_bx_mov_func = cast(_aux[2] as integer);
            end if;
                
        end if;
    end if;
    
    _ct_alt := false;
    
    if (tg_op = 'UPDATE') then
        _ct_alt := (coalesce(old.vl_ct, 0) <> coalesce(new.vl_ct, 0)) or
            (old.dt_emis <> new.dt_emis) or
            (old.dt_venc <> new.dt_venc) or
            (coalesce(old.obs, '') <> coalesce(new.obs, '')) or
            (coalesce(old.id_part, 0) <> coalesce(new.id_part, 0)) or
            (coalesce(old.id_part_dest, 0) <> coalesce(new.id_part_dest, 0)) or
            (coalesce(old.id_plano_ct, 0) <> coalesce(new.id_plano_ct, 0)) or
            (coalesce(old.id_cnt_cst, 0) <> coalesce(new.id_cnt_cst, 0)) or
            (coalesce(old.id_plano_ct_dest, 0) <> coalesce(new.id_plano_ct_dest, 0)) or
            (coalesce(old.id_cnt_cst_dest, 0) <> coalesce(new.id_cnt_cst_dest, 0));
    end if;
    
    
    --
    -- Exclui conta gerada pelo id_part_dest
    --
    if (tg_op = 'DELETE' and old.id_part_dest is not null) then
        _exc_ct_dest := true;
    elsif (tg_op = 'UPDATE' and old.id_part_dest is not null) then
        _exc_ct_dest := _ct_alt;
    end if;
    
    if (_exc_ct_dest) then
        delete from tb_ct
        where
            tp_org = 'CT' and
            id_org = old.id_ct;
    end if;
    
    --
    -- Exclui a baixa automatica
    --
    if (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        delete from tb_bx_ct 
        where
            id_emp = old.id_emp and
            org = 'CT.' || old.id_ct;
    end if;
    
    --
    -- Sef for boleto gera o numero do boleto
    --
    if ( (tg_op = 'INSERT' or (tg_op = 'UPDATE' and coalesce(new.nr_doc, '') = '') ) 
        and _app_con <> 'NEO_UNI') then
        
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'BLT') and (new.tp_ct = 'R') then
            _nr_doc := fc_num_blt(new.id_emp, new.id_op_fnc, new.id_cnt_bnc);
            
            new.nr_doc := cast(_nr_doc as varchar);
        end if;
    end if;
    
    if ((tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con = 'NEO_UNI')) then
        
        select sum(tb_bx_ct__ct.vl_quit), min(tb_bx_ct__ct.vl_rest) into _vl_quit, _vl_rest
        from tb_bx_ct__ct
        where
            tb_bx_ct__ct.id_emp_ct = new.id_emp and
            tb_bx_ct__ct.id_ct = new.id_ct;
    

        new.vl_quit := coalesce(_vl_quit, 0);
        new.vl_rest := coalesce(_vl_rest, new.vl_ct);
        
        if (_vl_rest <= 0) then
            new.stat := 'Q';
        end if;
    end if;
    
    --
    -- Gera conta pelo id_part_dest
    --
    if (tg_op = 'INSERT' and new.id_part_dest is not null) then
        _ger_ct_dest := true;
    elsif (tg_op = 'UPDATE' and new.id_part_dest is not null) then
        _ger_ct_dest := _ct_alt;
    end if;
    
    if (_ger_ct_dest) then

        if (new.tp_ct = 'P') then
            _tp_ct := 'R';
        else
            _tp_ct := 'P';
        end if;
            
        _id_ct := nextval('sq_ct');
            
        insert into tb_ct
            (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
             dt_emis, dt_venc, vl_ct, stat, 
             emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
             org, tp_org, id_org, 
             id_op_fnc, vl_quit, vl_rest, 
             obs,
             id_plano_ct, id_cnt_cst,
             vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
             id_usr_cad, dt_hr_cad, id_usr_ult_alt, dt_hr_ult_alt, comp_cad, comp_ult_alt,
             id_ct_ctb_d, id_ct_ctb_c)
        values
            (new.id_emp, _id_ct, _tp_ct, new.tp_doc, new.id_part_dest, new.nr_doc, new.parc, new.qtd_parc, 
             new.dt_emis, new.dt_venc, new.vl_ct, 'P', 
             new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
             'CT.' || new.id_ct, 'CT', new.id_ct,
             new.id_op_fnc, new.vl_quit, new.vl_rest, 
             new.obs,
             new.id_plano_ct_dest, new.id_cnt_cst_dest,
             new.vl_sub_tot, new.vl_perc_desc, new.vl_desc, new.vl_perc_acr, new.vl_acr, 
             new.id_usr_cad, new.dt_hr_cad, new.id_usr_ult_alt, new.dt_hr_ult_alt, new.comp_cad, new.comp_ult_alt,
             new.id_ct_ctb_d, new.id_ct_ctb_c);
            
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    else
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_entr_item_bf (
)
RETURNS trigger AS
$body$
begin

    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        if (tg_op = 'UPDATE') then
            if (new.vl_qtd <> old.vl_qtd) and (coalesce(old.mov_estq, true)) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd);
            end if;
            
            if (new.vl_qtd <> old.vl_qtd) and (coalesce(new.mov_estq, true)) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd);
            end if;
        end if;
        
        
        if (tg_op = 'INSERT') and (coalesce(new.mov_estq, true)) then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd);
        end if;
        
        return new;
    
    elsif (tg_op = 'DELETE') then
        
        if (coalesce(old.mov_estq, true)) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd);
        end if;
        
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_entr_item
  ADD COLUMN mov_estq BOOLEAN;

