CREATE OR REPLACE FUNCTION public.fc_nf_at_prc (
  _id_emp integer,
  _id_nf integer,
  _alt_prc_vnd boolean,
  _alt_prc_cst boolean
)
RETURNS boolean AS
$body$
declare
    _nf record;
    _nf_item_list refcursor;
    _nf_item record;
    _op varchar;
    _op_inv varchar;
    _nat_op record;
    _item_alt boolean;
    
    _nf_item_cmp_cst_list refcursor;    
    _nf_item_cmp_cst record;
begin
    select * into _nf
    from tb_nf
    where
        id_emp = _id_emp and
        id_nf = _id_nf;
        
    if (_nf.tp_emis = '[T]') or (_nf.tp_emis = '[P]' and _nf.tp_op = '[E]' ) then
        
        select * into _nat_op
        from tb_nat_op
        where
            id_nat_op = _nf.id_nat_op;
            
            
        open _nf_item_list for 
            select *
            from tb_nf_item
            where
                id_emp = _id_emp and
                id_nf  = _id_nf;
        
        fetch _nf_item_list into _nf_item;
        
        while found loop
            _item_alt := false;
            
            if (_nf_item.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_CST]%') or (_alt_prc_cst) then
                _item_alt := true;
                
                update tb_item_emp set
                	vl_cst_brt        = _nf_item.vl_tot / _nf_item.vl_qtd_mov,
                    vl_desp           = _nf_item.vl_frete + _nf_item.vl_seg + _nf_item.vl_out,
                    vl_perc_icms      = _nf_item.vl_perc_icms_prc,
                    vl_icms           = _nf_item.vl_icms_prc,
                    vl_perc_icms_st   = _nf_item.vl_perc_icms_st_prc,
                    vl_icms_st        = _nf_item.vl_icms_st_prc,
                    vl_perc_fcp_st    = _nf_item.vl_perc_fcp_st_prc,
                    vl_fcp_st         = _nf_item.vl_fcp_st_prc,
                    vl_perc_ipi       = _nf_item.vl_perc_ipi_prc,
                    vl_ipi            = _nf_item.vl_ipi_prc,
                    vl_perc_pis       = _nf_item.vl_perc_pis_prc,
                    vl_pis            = _nf_item.vl_pis_prc,
                    vl_perc_cofins    = _nf_item.vl_perc_cofins_prc,
                    vl_cofins         = _nf_item.vl_cofins_prc,
                    vl_desc           = _nf_item.vl_desc,
                    vl_cst_rep        = _nf_item.vl_cst_rep,
                    vl_cst_med        = _nf_item.vl_cst_med,
                    dt_ult_cmp        = _nf.dt_op,
                    id_usr_ult_alt    = _nf_item.id_usr_ult_alt,
                    dt_hr_ult_alt     = _nf_item.dt_hr_ult_alt,
                    comp_ult_alt      = _nf_item.comp_ult_alt
                where
                    id_emp  = _nf_item.id_emp and
                    id_item = _nf_item.id_item;
                    
                open _nf_item_cmp_cst_list for
                    select * 
                    from tb_nf_item_cmp_cst
                    where
                        id_emp = _nf_item.id_emp and
                        id_nf = _nf_item.id_nf and
                        id_nf_item = _nf_item.id_nf_item;
                        
                --
                -- Salva a composicao de custo no item
                -- 
                fetch _nf_item_cmp_cst_list into _nf_item_cmp_cst;
                
                while found loop
                    perform fc_item_cmp_cst(
                        _nf_item.id_item, 
                        _nf_item.id_emp, 
                        _nf_item_cmp_cst.id_cmp_cst, 
                        _nf_item_cmp_cst.vl_cst, 
                        _nf_item_cmp_cst.vl_perc,
                        0);
                    
                    fetch _nf_item_cmp_cst_list into _nf_item_cmp_cst;
                end loop;
                
                close _nf_item_cmp_cst_list;
            end if;
                
            if (_nf_item.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_VND]%') or (_alt_prc_vnd) then
                _item_alt := true;
                
                update tb_item_emp set
                    vl_out              = _nf_item.vl_out_prc,
                    vl_perc_desp_op     = _nf_item.vl_perc_desp_op_prc,
                    vl_desp_op          = _nf_item.vl_desp_op_prc,
                    vl_perc_luc         = _nf_item.vl_perc_luc_prc,
                    vl_luc              = _nf_item.vl_luc_prc,
                    vl_prc_vnd          = _nf_item.vl_prc_vnd,
                    id_usr_ult_alt      = _nf_item.id_usr_ult_alt,
                    dt_hr_ult_alt       = _nf_item.dt_hr_ult_alt,
                    comp_ult_alt        = _nf_item.comp_ult_alt
                where
                    id_emp  = _nf_item.id_emp and
                    id_item = _nf_item.id_item;

                if (coalesce(_nf_item.promo, false)) then
                    update tb_item_emp set
                        promo            = _nf_item.promo,
                        vl_prc_vnd_promo = _nf_item.vl_prc_vnd_promo,
                        id_usr_ult_alt   = _nf_item.id_usr_ult_alt,
                        dt_hr_ult_alt    = _nf_item.dt_hr_ult_alt,
                        comp_ult_alt     = _nf_item.comp_ult_alt
                    where
                        id_emp  = _nf_item.id_emp and
                        id_item = _nf_item.id_item;
                end if;
            end if;
            
            if (_item_alt) then
                update tb_item set
                    id_usr_ult_alt = _nf_item.id_usr_ult_alt,
                    dt_hr_ult_alt  = _nf_item.dt_hr_ult_alt,
                    comp_ult_alt   = _nf_item.comp_ult_alt
                where
                    id_item = _nf_item.id_item;
            end if;
        
            fetch _nf_item_list into _nf_item;
            
        end loop;
            
    end if;
    
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_restart_sequence (
)
RETURNS boolean AS
$body$
declare
    v_cur refcursor;
    v_rec record;
    v_op varchar;
    v_id_max integer;
    v_aux integer;
    v_sql varchar;
begin

    select count(*) into v_aux
    from tb_est;
    
    if (v_aux > 1) then
        raise exception 'Existe mais de uma estação cadastrada, execute a funcao de iniciar estação';
        return false;
    end if;

 
    open v_cur for
        select relname, substring(relname, 4, length(relname)) as "entidade"
        from pg_class
        where 
            relname like 'sq_%';
     
    fetch v_cur into v_rec;
     
    while found loop
     
        select count(*) into v_aux
        from pg_class
        where
            relname = 'tb_' || v_rec."entidade";
         
        if (v_aux > 0) then
            v_sql := 'select max("id_' || v_rec."entidade" || '")::integer ' ||
                'from "tb_' || v_rec."entidade" || '"';
            if (v_rec.entidade = 'tb_cmp_cst') then
                v_sql := v_sql + ' where id_cmp_cst < 1000';
            end if;
                
                
            execute v_sql into v_id_max;
         
            raise notice '[% %]   ', v_rec."relname", v_id_max;
             
            if (v_id_max is not null) then
                execute 'alter sequence "' || v_rec."relname" || '" restart with ' || v_id_max + 1;
            else
                execute 'alter sequence "' || v_rec."relname" || '" restart with 1';
            end if;
        end if;
         
        fetch v_cur into v_rec;
    end loop;
     
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

