CREATE OR REPLACE FUNCTION public.fc_tr_pdc_colab_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _op_fnc record;
    _id_ct integer;
    _perf_sis varchar;
BEGIN
    select * into _op_fnc
    from tb_op_fnc
    where
        tp_op_fnc = 'DUP'
    limit 1;
    
    if (tg_op = 'UPDATE' or tg_op = 'DELETE') then
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            tp_org = 'PDC_COLAB' and
            id_org = old.id_pdc_colab;
            -- org = 'PDC_COLAB.' || old.id_pdc_colab;
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        select fc_get_emp_cnf(new.id_emp, 01024) into _perf_sis;
    
        if (new.vl_tot <> 0) and (_perf_sis <> 'COOP_TRAB') then
            _id_ct := nextval('sq_ct');
        
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                 dt_emis, dt_venc, vl_ct, stat, 
                 org, tp_org, id_org,
                 id_op_fnc, vl_quit, vl_rest, 
                 id_plano_ct,
                 vl_sub_tot, vl_perc_desc, vl_desc, vl_perc_acr, vl_acr, 
                 id_usr_ult_alt, dt_hr_ult_alt)
            values
                (new.id_emp, _id_ct, 'P', _op_fnc.tp_op_fnc, new.id_colab, new.id_pdc_colab, 1, 1,
                 new.dt_pdc_colab, new.dt_venc, new.vl_tot, 'P', 
                 'PDC_COLAB.' || new.id_pdc_colab, 'PDC_COLAB', new.id_pdc_colab, 
                 _op_fnc.id_op_fnc, 0, new.vl_tot, 
                 new.id_plano_ct,
                 new.vl_tot, 0, 0, 0, 0, 
                 new.id_usr_ult_alt, new.dt_hr_ult_alt);
        end if;
    
    end if;
    
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
        return new;
    else 
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_part_base
  ALTER COLUMN tp_part TYPE VARCHAR(100) COLLATE pg_catalog."default";

