drop view vw_mov_plano_ct;

create view vw_mov_plano_ct
as

select 
    tb_bx_ct.id_emp,
    'BX_CT.' || tb_bx_ct.id_bx_ct || '.' || tb_ct.id_ct as id_mov_plano_ct,
    'BX_CT.' || tb_bx_ct.id_bx_ct || '.' || tb_ct.id_ct as org,
    'BX_CT' as tp_org,
    tb_bx_ct.id_bx_ct as id_org,
    tb_ct.id_ct as id_org_item,
    tb_ct.id_plano_ct,
    tb_bx_ct.dt_bx as dt_lanc,
    tb_part.nome as descr,
    tb_bx_ct__ct.vl_quit as vl_lanc
from tb_bx_ct
join tb_bx_ct__ct on 
    (tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp and
     tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct)
join tb_ct on 
    (tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp and
     tb_bx_ct__ct.id_ct = tb_ct.id_ct)
join tb_plano_ct _plano_ct on 
    (tb_ct.id_plano_ct = _plano_ct.id_plano_ct)
join tb_part on 
    (tb_ct.id_part = tb_part.id_part)
where
    coalesce(tb_ct.tp_org, '') <> 'CONTR_FRETE'

union all

select 
    tb_mov_bnc.id_emp,
    'MOV_BNC.' || tb_mov_bnc.id_mov_bnc as id_mov_plano_ct,
    'MOV_BNC.' || tb_mov_bnc.id_mov_bnc as org,
    'MOV_BNC' as tp_org,
    tb_mov_bnc.id_mov_bnc as id_org,
    null as id_org_item,
    tb_mov_bnc.id_plano_ct,
    tb_mov_bnc.dt_emis as dt_lanc,
    coalesce(tb_part.nome || ' - ', '') || tb_mov_bnc.descr as descr,
    tb_mov_bnc.vl_lanc
from tb_mov_bnc
join tb_plano_ct _plano_ct on 
    (tb_mov_bnc.id_plano_ct = _plano_ct.id_plano_ct)
left outer join tb_part on 
    (tb_mov_bnc.id_part = tb_part.id_part)
where 
    not coalesce(tb_mov_bnc.org, '') like 'BX.%'
    
union all

select 
    tb_mov_fnc.id_emp,
    'MOV_FNC.' || tb_mov_fnc.id_mov_fnc as id_mov_plano_ct,
    'MOV_FNC.' || tb_mov_fnc.id_mov_fnc as org,
    'MOV_FNC' as tp_org,
    tb_mov_fnc.id_mov_fnc as id_org,
    null as id_org_item,
    tb_mov_fnc.id_plano_ct,
    tb_mov_fnc.dt_lanc,
    tb_mov_fnc.descr,
    tb_mov_fnc.vl_lanc
from tb_mov_fnc
join tb_plano_ct _plano_ct on 
    (tb_mov_fnc.id_plano_ct = _plano_ct.id_plano_ct)
where 
    tb_mov_fnc.org is null

union all

select 
    tb_vnd.id_emp,
    'VND.' || tb_vnd.id_vnd || '.' || tb_vnd_parc.id_vnd_parc as id_mov_plano_ct,
    'VND.' || tb_vnd.id_vnd || '.' || tb_vnd_parc.id_vnd_parc as org,
    'VND' as tp_org,
    tb_vnd.id_vnd as id_org,
    tb_vnd_parc.id_vnd_parc as id_org_item,
    tb_emp_cnf.val as id_plano_ct,
    tb_vnd.dt_vnd as dt_lanc,
    tb_part.nome as descr,
    tb_vnd_parc.vl_parc as vl_lanc
from tb_vnd
join tb_vnd_parc on 
    (tb_vnd.id_emp = tb_vnd_parc.id_emp and 
     tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
join tb_op_fnc on 
    (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc)
join tb_part on 
    (tb_vnd.id_cli = tb_part.id_part)
left join tb_emp_cnf on 
    (tb_vnd.id_emp = tb_emp_cnf.id_emp and 
     trunc(tb_emp_cnf.id_cnf / 100) = 161 and 
     (tb_emp_cnf.id_cnf - 16100) = tb_op_fnc.id_op_fnc)
where 
    coalesce(tb_vnd.canc, false) = false
    
union all 

select 
    tb_bx_ct.id_emp,
    'CONTR_FRETE.' || tb_bx_ct.id_bx_ct || '.' || tb_ct.id_ct || '.' || tb_emp_cnf.id_cnf as id_mov_plano_ct,
    'CONTR_FRETE.' || tb_bx_ct.id_bx_ct || '.' || tb_ct.id_ct as org,
    'CONTR_FRETE' as tp_org,
    tb_bx_ct.id_bx_ct as id_org,
    tb_ct.id_ct as id_org_item,
    tb_emp_cnf.val as id_plano_ct,
    tb_bx_ct.dt_bx as dt_lanc,
    tb_part.nome as descr,
    case tb_emp_cnf.id_cnf
        when 26101 then tb_contr_frete.vl_frete 
        when 26102 then tb_contr_frete.vl_inss
        when 26103 then tb_contr_frete.vl_irrf
        when 26104 then tb_contr_frete.vl_ss
        when 26105 then tb_contr_frete.vl_taxa_coop
        when 26106 then tb_contr_frete.vl_dif_frete
        when 26107 then (tb_contr_frete.vl_dif_frete * -1)
        when 26108 then tb_contr_frete.vl_desc_fin
        when 26109 then tb_contr_frete.vl_seg
        when 26110 then case when (tb_tp_contr_frete.conf like '%[ADTO_T]%') then tb_contr_frete.vl_adto else 0 end
        when 26111 then tb_contr_frete.vl_comis1
        when 26112 then tb_contr_frete.vl_taxa_op
        when 26113 then tb_contr_frete.vl_aliq_ldc
        when 26114 then tb_contr_frete.vl_issqn
        when 26115 then tb_contr_frete.vl_out_desp
    end as vl_lanc
from tb_bx_ct
join tb_bx_ct__ct on 
    (tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp and
     tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct)
join tb_ct on 
    (tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp and
     tb_bx_ct__ct.id_ct = tb_ct.id_ct)
left join tb_plano_ct _plano_ct on 
    (tb_ct.id_plano_ct = _plano_ct.id_plano_ct)
join tb_part on 
    (tb_ct.id_part = tb_part.id_part)
join tb_contr_frete on
    (tb_contr_frete.id_emp = tb_ct.id_emp and
     tb_contr_frete.id_contr_frete = tb_ct.id_org)
join tb_emp_cnf on
    (tb_ct.id_emp = tb_emp_cnf.id_emp and
     tb_emp_cnf.id_cnf between 26101 and 26115)
join tb_tp_contr_frete on
    (tb_contr_frete.id_tp_contr_frete = tb_tp_contr_frete.id_tp_contr_frete)
where
    coalesce(tb_ct.tp_org, '') = 'CONTR_FRETE'
    
union all

select 
    tb_bx_ct.id_emp,
    'ACT.' || tb_bx_ct.id_bx_ct || '.' || tb_bx_ct_pagto.id_bx_ct_pagto || '.' || tb_emp_cnf.id_cnf as id_mov_plano_ct,
    'ACT.' || tb_bx_ct.id_bx_ct || '.' || tb_bx_ct_pagto.id_bx_ct_pagto as org,
    'ACT' as tp_org,
    tb_bx_ct.id_bx_ct as id_org,
    tb_bx_ct_pagto.id_bx_ct_pagto as id_org_item,
    tb_emp_cnf.val as id_plano_ct,
    tb_bx_ct.dt_bx as dt_lanc,
    tb_part.nome as descr,
    tb_bx_ct_pagto.vl_pagto as vl_lanc
from tb_bx_ct
join tb_bx_ct_pagto on 
    (tb_bx_ct.id_emp = tb_bx_ct_pagto.id_emp and
     tb_bx_ct.id_bx_ct = tb_bx_ct_pagto.id_bx_ct)
join tb_part on 
    (tb_bx_ct.id_part = tb_part.id_part)
join tb_emp_cnf on
    (tb_bx_ct.id_emp = tb_emp_cnf.id_emp and
     tb_emp_cnf.id_cnf = 24029)
join tb_op_fnc on
    (tb_bx_ct_pagto.id_op_fnc = tb_op_fnc.id_op_fnc)
where
    tb_bx_ct.op = 'A' and
    tb_op_fnc.tp_op_fnc in ('DUP', 'BLT')
    
union all

select 
    tb_bx_ct.id_emp,
    'MOV_FUNC.' || tb_bx_ct.id_bx_ct || '.' || tb_mov_func.id_mov_func as id_mov_plano_ct,
    'MOV_FUNC.' || tb_bx_ct.id_bx_ct || '.' || tb_mov_func.id_mov_func as org,
    'MOV_FUNC' as tp_org,
    tb_bx_ct.id_bx_ct as id_org,
    tb_mov_func.id_mov_func as id_org_item,
    tb_mov_func.id_plano_ct,
    tb_bx_ct.dt_bx as dt_lanc,
    tb_part.nome as descr,
    tb_mov_func.vl_lanc as vl_lanc
from tb_bx_ct
join tb_bx_ct__ct on 
    (tb_bx_ct.id_emp = tb_bx_ct__ct.id_emp and
     tb_bx_ct.id_bx_ct = tb_bx_ct__ct.id_bx_ct)
join tb_ct on 
    (tb_bx_ct__ct.id_emp_ct = tb_ct.id_emp and
     tb_bx_ct__ct.id_ct = tb_ct.id_ct)
join tb_mov_func on 
    (tb_bx_ct.id_emp = tb_mov_func.id_emp and
     tb_ct.org = 'BX_MOV_FUNC.' || tb_mov_func.id_bx_mov_func)
join tb_plano_ct _plano_ct on 
    (tb_mov_func.id_plano_ct = _plano_ct.id_plano_ct)
join tb_part on 
    (tb_mov_func.id_part = tb_part.id_part)
;