SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_ped_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _item record;
    _exc_estq boolean;
    _inc_estq boolean;
BEGIN
    --
    -- Baixa somente o estoque da origem (MATRIZ), posteriormente no neo, baixa o do destino (ESTACAO)
    --
    /*
    if (tg_op = 'UPDATE') then

        if (new.vl_qtd_mov <> old.vl_qtd_mov) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
        end if;

    elsif (tg_op = 'INSERT') then
        
        perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
    
    elsif (tg_op = 'DELETE') then
        
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);

    end if;
*/

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    else
        return old;
    end if;


    /*
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        select * into _item
        from tb_item
        where
            id_item = new.id_item;
    else
        select * into _item
        from tb_item
        where
            id_item = old.id_item;
    end if;
    
    _exc_estq := false;
    _inc_estq := false;
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and 
        (coalesce(old.id_dep, -1) <> coalesce(old.id_dep_dst, -1)) and
        (old.vl_qtd_mov <> new.vl_qtd_mov) then
        
        _exc_estq := true;
    
    end if;
    
    if ( (tg_op = 'INSERT') and (coalesce(new.id_dep, -1) <> coalesce(new.id_dep_dst, -1)) ) or
        ( (tg_op = 'UPDATE') and (coalesce(new.id_dep, -1) <> coalesce(new.id_dep_dst, -1)) and (old.vl_qtd_mov <> new.vl_qtd_mov) ) then
        
        _inc_estq := true;
        
    end if;
        
    
    
    if (_exc_estq) then
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep_dst, old.id_grd_estq, 'S', old.vl_qtd_mov);
    end if;
    
    if (_inc_estq) then
        perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
        perform fc_item_estq(new.id_item, new.id_emp, new.id_dep_dst, new.id_grd_estq, 'E', new.vl_qtd_mov);
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    else
        return old;
    end if;
    
    */
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_mov_bnc_bf (
)
RETURNS trigger AS
$body$
declare
    _ch record;
    _id_ch_sit integer;
    _ch_sit record;
    _op_fnc record;
begin
    if (tg_op = 'INSERT' and new.id_op_fnc is not null) then
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (coalesce(_op_fnc.auto_conc, false) = true) then
            new.conc := true;
            new.dt_conc := new.dt_venc;
        end if;
    
    end if;

    if (tg_op = 'UPDATE' and old.conc <> new.conc and new.org = 'ch') then
        if (new.conc) then
        
            if (new.sit_conc = 'CONC') then
                perform fc_sit_ch(new.id_emp, new.id_org, 'Q', 'QUITADO', new.dt_conc, null);
            elsif (new.sit_conc = 'CHDEV') then
                select * into _ch
                from tb_ch
                where 
                    id_emp = new.id_emp and
                    id_ch = new.id_org;

                if (_ch.dt_dev1 is null) then
                
                    update tb_ch set
                        sit = 'D',
                        dt_dev1 = new.dt_conc,
                        id_mtv_dev_ch1 = new.id_mtv_dev_ch
                    where 
                        id_emp = new.id_emp and
                        id_ch = new.id_org;
                else
                    update tb_ch set
                        sit = 'D',
                        dt_dev2 = new.dt_conc,
                        id_mtv_dev_ch2 = new.id_mtv_dev_ch
                    where 
                        id_emp = new.id_emp and
                        id_ch = new.id_org;
                end if;
                
                perform fc_sit_ch(new.id_emp, new.id_org, 'D', 'DEVOLVIDO', new.dt_conc, null);
                
                
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, 
                     descr, conc, org, id_org, id_part, dt_conc, sit_conc, id_mtv_dev_ch,
                     id_op_fnc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_lanc, 
                     'CHEQUE DEVOLVIDO', new.conc, 'mov_bnc', new.id_mov_bnc, new.id_part, new.dt_conc, new.sit_conc, new.id_mtv_dev_ch,
                     new.id_op_fnc);
            end if;
            
        elsif (not new.conc) then
            select max(id_ch_sit) into _id_ch_sit
            from tb_ch_sit
            where
                id_emp = new.id_emp and
                id_ch = new.id_org and
                sit in ('Q', 'D');
                
            select * into _ch_sit
            from tb_ch_sit
            where
                id_emp = new.id_emp and
                id_ch = new.id_org and
                id_ch_sit < _id_ch_sit
            order by
                id_ch_sit desc
            limit 1;
            
            if found then
            
                update tb_ch set
                    dt_sit = _ch_sit.dt_sit,
                    sit = _ch_sit.sit
                where
                    id_emp = new.id_emp and
                    id_ch = new.id_org;
                
                delete from tb_ch_sit
                where
                    id_emp = new.id_emp and
                    id_ch = new.id_org and
                    id_ch_sit = _id_ch_sit;
                    
            end if;
            
            if (old.sit_conc = 'CHDEV' and old.org = 'ch') then
                delete from tb_mov_bnc
                where
                    id_emp = new.id_emp and
                    org = 'mov_bnc' and
                    id_org = new.id_mov_bnc;
            end if;
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    elsif (tg_op = 'DELETE') then
        if (old.org = 'ch') then
            delete from tb_mov_bnc
            where
                id_emp = old.id_emp and
                org = 'mov_bnc' and
                id_org = old.id_mov_bnc;
        end if;
            
        return old;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_op_fnc
  ADD COLUMN auto_conc BOOLEAN;

