SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_contr_frete_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _contr_frete record;
    _op_fnc record;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'CONTR_FRETE.PAGTO.' || old.id_contr_frete || '.' || old.id_contr_frete_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'CONTR_FRETE.PAGTO.' || old.id_contr_frete || '.' || old.id_contr_frete_pagto;
        
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        select * into _contr_frete
        from tb_contr_frete
        where
            id_emp = new.id_emp and
            id_contr_frete = new.id_contr_frete;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.gera_ct) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 id_cnt_bnc, org, id_op_fnc, vl_quit, vl_rest,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst, obs,
                 id_ct_ctb_d, id_ct_ctb_c)
            values
                (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, _contr_frete.id_tom, new.nr_doc,
                 _contr_frete.dt_emis, new.dt_venc, new.vl_pagto, 'P', 
                 new.id_cnt_bnc, 'CONTR_FRETE.PAGTO.' || new.id_contr_frete || '.' || new.id_contr_frete_pagto, new.id_op_fnc, 0, new.vl_pagto,
                 _contr_frete.id_usr_ult_alt, _contr_frete.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst, new.obs,
                 new.id_ct_ctb_d, new.id_ct_ctb_c);
                     
        end if;
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc,
                 id_usr_ult_alt, dt_hr_ult_alt,
                 id_plano_ct, id_cnt_cst,
                 id_ct_ctb_d, id_ct_ctb_c,
                 id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _contr_frete.dt_emis, new.dt_venc, new.nr_doc, 'C', new.vl_pagto, new.obs, false,
                 'CONTR_FRETE.PAGTO.' || new.id_contr_frete || '.' || new.id_contr_frete_pagto, _contr_frete.id_contr_frete,
                 _contr_frete.id_tom, 'PEND',
                 _contr_frete.id_usr_ult_alt, _contr_frete.dt_hr_ult_alt,
                 new.id_plano_ct, new.id_cnt_cst,
                 new.id_ct_ctb_d, new.id_ct_ctb_c,
                 new.id_op_fnc);
        
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;

end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

CREATE TABLE public.tb_contr_frete_pagto (
  id_emp INTEGER NOT NULL, 
  id_contr_frete INTEGER NOT NULL, 
  id_contr_frete_pagto INTEGER NOT NULL, 
  id_cnt_bnc INTEGER, 
  id_op_fnc INTEGER, 
  dt_venc DATE, 
  vl_pagto NUMERIC(12,4), 
  nr_doc VARCHAR(20), 
  id_plano_ct VARCHAR(100), 
  id_cnt_cst INTEGER, 
  obs VARCHAR(255), 
  id_ct_ctb_d INTEGER, 
  id_ct_ctb_c INTEGER, 
  CONSTRAINT pk_contr_frete_pagto PRIMARY KEY(id_emp, id_contr_frete, id_contr_frete_pagto)
) ;

CREATE TRIGGER tr_contr_frete_pagto_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_contr_frete_pagto FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_contr_frete_pagto_bf();

ALTER TABLE public.tb_contr_frete_pagto
  ADD CONSTRAINT fk__contr_frete_pagto__cnt_bnc FOREIGN KEY (id_emp, id_cnt_bnc)
    REFERENCES public.tb_cnt_bnc(id_emp, id_cnt_bnc)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_contr_frete_pagto
  ADD CONSTRAINT fk__contr_frete_pagto__cnt_cst FOREIGN KEY (id_cnt_cst)
    REFERENCES public.tb_cnt_cst(id_cnt_cst)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_contr_frete_pagto
  ADD CONSTRAINT fk__contr_frete_pagto__contr_frete FOREIGN KEY (id_emp, id_contr_frete)
    REFERENCES public.tb_contr_frete(id_emp, id_contr_frete)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_contr_frete_pagto
  ADD CONSTRAINT fk__contr_frete_pagto__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_contr_frete_pagto
  ADD CONSTRAINT fk__contr_frete_pagto__plano_ct FOREIGN KEY (id_plano_ct)
    REFERENCES public.tb_plano_ct(id_plano_ct)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

