CREATE SEQUENCE public.sq_bx_mov_func
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE TABLE public.tb_ct_ctb (
  id_ct_ctb INTEGER NOT NULL, 
  descr VARCHAR(500), 
  obs TEXT, 
  clas VARCHAR(50), 
  tp_ct_ctb VARCHAR(1), 
  CONSTRAINT pk_ct_ctb PRIMARY KEY(id_ct_ctb)
) ;

SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_gera_mov_fnc (
  _tb_org varchar,
  _id_emp integer,
  _id_org integer,
  _id_mov_cx integer
)
RETURNS boolean AS
$body$
declare
    _org_list refcursor;
    _org record;
    _seq integer;
begin

    if (_tb_org = 'tb_vnd') then
        /*delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'VND.' || _id_org || '%';*/
    
        open _org_list for
            select
                tb_vnd.id_cx as id_cx,
                tb_vnd.id_usr as id_usr,
                tb_vnd.id_vnd as id_org,
                tb_vnd.dt_vnd as dt_lanc,
                cast(case when coalesce(tb_vnd.canc, false) then 'CANC VENDA: ' else 'VENDA: ' end || coalesce(tb_vnd.nome, '') as varchar) as descr,
                cast(case when coalesce(tb_vnd.canc, false) then 'D' else 'C' end as varchar) as op,
                sum(tb_vnd_parc.vl_parc) as vl_lanc,
                cast('VND.' || tb_vnd.id_vnd || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_vnd.id_vnd as varchar) as doc,
                tb_vnd.dt_hr_cad,
                tb_vnd.dt_hr_ult_alt,
                tb_vnd.id_est_cad,
                tb_vnd.id_est_ult_alt,
                tb_vnd.id_usr_cad, 
                tb_vnd.id_usr_ult_alt
            from tb_vnd
            join tb_vnd_parc on
                (tb_vnd.id_emp = tb_vnd_parc.id_emp and
                 tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
            join tb_op_fnc on
                (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_vnd.id_emp = _id_emp and
                tb_vnd.tp_vnd = 'V' and
                tb_vnd.id_vnd = _id_org
            group by
                tb_vnd.id_cx,
                tb_vnd.id_vnd,
                tb_vnd.id_usr,
                tb_vnd.dt_vnd,
                tb_vnd.nome,
                tb_vnd.canc,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_vnd.dt_hr_cad,
                tb_vnd.dt_hr_ult_alt,
                tb_vnd.id_est_cad,
                tb_vnd.id_est_ult_alt,
                tb_vnd.id_usr_cad, 
                tb_vnd.id_usr_ult_alt;
                
    elsif (_tb_org = 'tb_bx_ct') then
    
        /*delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'BX.' || _id_org || '%';*/
    
        open _org_list for
            select
                tb_bx_ct.id_cx as id_cx,
                tb_bx_ct.id_usr as id_usr,
                tb_bx_ct.id_bx_ct as id_org,
                tb_bx_ct.dt_bx as dt_lanc,
                cast(
                    case 
                        when (coalesce(tb_bx_ct.op = 'R')) then 'RENEG: ' || coalesce(tb_part.nome, '')
                        when (tb_bx_ct.tp_bx = 'R') then ifthen(coalesce(tb_bx_ct.canc, false), 'ESTORNO DE ', '') || 'REC: ' || coalesce(tb_part.nome, '')
                        when (tb_bx_ct.tp_bx = 'P') then ifthen(coalesce(tb_bx_ct.canc, false), 'ESTORNO DE ', '') || 'PAG: ' || coalesce(tb_part.nome, '') 
                    end
                as varchar) as descr,
                cast(
                    case 
                        when (tb_bx_ct.tp_bx = 'R' and coalesce(tb_bx_ct.canc, false) = false) then 'C'
                        when (tb_bx_ct.tp_bx = 'R' and coalesce(tb_bx_ct.canc, false) = true) then 'D'
                        when (tb_bx_ct.tp_bx = 'P' and coalesce(tb_bx_ct.canc, false) = false) then 'D'
                        when (tb_bx_ct.tp_bx = 'P' and coalesce(tb_bx_ct.canc, false) = true) then 'C'
                    end 
                as varchar) as op,
--                cast(ifthen(tb_bx_ct.tp_bx = 'R', 'C', 'D') as varchar) as op,
                sum(tb_bx_ct_pagto.vl_pagto) as vl_lanc,
                cast('BX.' || tb_bx_ct.id_bx_ct || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_bx_ct.id_bx_ct as varchar) as doc,
                tb_bx_ct.dt_hr_cad,
                tb_bx_ct.dt_hr_ult_alt,
                tb_bx_ct.id_est_cad,
                tb_bx_ct.id_est_ult_alt,
                tb_bx_ct.id_usr_cad, 
                tb_bx_ct.id_usr_ult_alt
            from tb_bx_ct
            join tb_bx_ct_pagto on
                (tb_bx_ct.id_emp = tb_bx_ct_pagto.id_emp and
                 tb_bx_ct.id_bx_ct = tb_bx_ct_pagto.id_bx_ct)
            left outer join tb_part on
                (tb_bx_ct.id_part = tb_part.id_part)
            join tb_op_fnc on
                (tb_bx_ct_pagto.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true))
            where
                tb_bx_ct.id_emp = _id_emp and
                tb_bx_ct.id_bx_ct = _id_org
            group by
                tb_bx_ct.id_cx,
                tb_bx_ct.id_bx_ct,
                tb_bx_ct.tp_bx,
                tb_bx_ct.canc,
                tb_bx_ct.id_usr,
                tb_bx_ct.dt_bx,
                tb_part.nome,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_bx_ct.op,
                tb_bx_ct.dt_hr_cad,
                tb_bx_ct.dt_hr_ult_alt,
                tb_bx_ct.id_est_cad,
                tb_bx_ct.id_est_ult_alt,
                tb_bx_ct.id_usr_cad, 
                tb_bx_ct.id_usr_ult_alt;
    
    elsif (_tb_org = 'tb_nf') then
    
        /*delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            org like 'NF.' || _id_org || '%';*/
    
        open _org_list for
            select
                tb_nf.id_cx as id_cx,
                tb_nf.id_usr as id_usr,
                tb_nf.id_nf as id_org,
                tb_nf.dt_op as dt_lanc,
                cast(ifthen(coalesce(tb_nf.canc, false), 'CANC ', '') || 'NF: ' || coalesce(tb_nf.fant_emt, '') as varchar) as descr,
                cast(
                    case 
                        when (coalesce(tb_nf.canc, false) = false) then 'D'
                        else 'C'
                    end 
                as varchar) as op,
--                cast('D' as varchar) as op,
                sum(tb_nf_parc.vl_parc) as vl_lanc,
                cast('NF.' || tb_nf.id_nf || '.' || tb_op_fnc.id_op_fnc as varchar) as org,
                tb_op_fnc.id_op_fnc,
                cast(tb_nf.num as varchar) as doc,
                tb_nf.dt_hr_cad,
                tb_nf.dt_hr_ult_alt,
                tb_nf.id_est_cad,
                tb_nf.id_est_ult_alt,
                tb_nf.id_usr_cad, 
                tb_nf.id_usr_ult_alt
            from tb_nf
            join tb_nf_parc on
                (tb_nf.id_emp = tb_nf_parc.id_emp and
                 tb_nf.id_nf = tb_nf_parc.id_nf)
            join tb_op_fnc on
                (tb_nf_parc.id_op_fnc = tb_op_fnc.id_op_fnc and
                 coalesce(tb_op_fnc.mov_cx, true) and
                 tb_op_fnc.tp_op_fnc = 'DIN')
            where
                tb_nf.id_emp = _id_emp and
                tb_nf.id_nf = _id_org and
                tb_nf.tp_emis = '[T]'
            group by
                tb_nf.id_cx,
                tb_nf.id_nf,
                tb_nf.id_usr,
                tb_nf.dt_op,
                tb_nf.canc,
                tb_nf.num,
                tb_nf.fant_emt,
                tb_op_fnc.id_op_fnc,
                tb_op_fnc.descr,
                tb_nf.dt_hr_cad,
                tb_nf.dt_hr_ult_alt,
                tb_nf.id_est_cad,
                tb_nf.id_est_ult_alt,
                tb_nf.id_usr_cad, 
                tb_nf.id_usr_ult_alt;
    
    end if;

    


    fetch _org_list into _org;
    
    while found loop

        _seq := fc_get_seq_mov_fnc(_id_emp, _org.id_cx);
    
        insert into tb_mov_fnc
            (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc,
             descr, op, vl_lanc, org, id_org, id_op_fnc, doc,
             dt_hr_cad, dt_hr_ult_alt, id_usr_cad, id_usr_ult_alt, id_est_cad, id_est_ult_alt, 
             seq, id_mov_cx)
        values
            (_id_emp, nextval('sq_mov_fnc'), _org.id_cx, _org.id_usr, _org.dt_lanc, substring(cast(current_time as varchar), 1, 8)::time, 
             _org.descr, _org.op, _org.vl_lanc, _org.org, _org.id_org, _org.id_op_fnc, _org.doc,
             _org.dt_hr_cad, CURRENT_TIMESTAMP, _org.id_usr_cad, _org.id_usr_ult_alt, _org.id_est_cad, _org.id_est_ult_alt, 
             _seq, _id_mov_cx);
    
        fetch _org_list into _org;
        
    end loop;
    
    close _org_list;


    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_part
  ADD COLUMN id_resp INTEGER;

ALTER TABLE public.tb_mov_func
  ADD COLUMN id_bx_mov_func INTEGER;

ALTER TABLE public.tb_mov_bnc
  ADD COLUMN id_ct_ctb_d INTEGER;

ALTER TABLE public.tb_mov_bnc
  ADD COLUMN id_ct_ctb_c INTEGER;

COMMENT ON COLUMN public.tb_vnd.tp_vnd
IS '[V] Venda [O] Oramento [C] Condicional [OS] Ordem servico';

ALTER TABLE public.tb_bx_ct
  ADD COLUMN org VARCHAR(50);

ALTER TABLE public.tb_ct
  ADD COLUMN id_ct_ctb_d INTEGER;

ALTER TABLE public.tb_ct
  ADD COLUMN id_ct_ctb_c INTEGER;

CREATE OR REPLACE VIEW public.vw_vnd_rota (
    id_emp,
    dt_vnd,
    dia_semana,
    id_rota,
    id_vndr,
    descr,
    vl_cred,
    vl_ch_prz,
    vl_ch_vst,
    vl_blt,
    vl_out,
    qtd_cli)
AS
 SELECT tb.id_emp, tb.dt_vnd, tb.dia_semana, tb.id_rota, tb.id_vndr, tb.descr, 
    sum(tb.vl_cred) AS vl_cred, sum(tb.vl_ch_prz) AS vl_ch_prz, 
    sum(tb.vl_ch_vst) AS vl_ch_vst, sum(tb.vl_blt) AS vl_blt, 
    sum(tb.vl_out) AS vl_out, sum(tb.qtd_cli) AS qtd_cli
   FROM (        (        (        (        (         SELECT tb_vnd.id_emp, 
                                                    tb_vnd.dt_vnd, 
                                                        CASE date_part('dow'::text, tb_vnd.dt_vnd)
                                                            WHEN 0 THEN 'Domingo'::text
                                                            WHEN 1 THEN 'Segunda'::text
                                                            WHEN 2 THEN 'Tera'::text
                                                            WHEN 3 THEN 'Quarta'::text
                                                            WHEN 4 THEN 'Quinta'::text
                                                            WHEN 5 THEN 'Sexta'::text
                                                            WHEN 6 THEN 'Sabado'::text
                                                            ELSE NULL::text
                                                        END AS dia_semana, 
                                                    tb_part.id_rota, 
                                                    tb_vnd.id_vndr, 
                                                    tb_rota.descr, 0 AS vl_cred, 
                                                    0 AS vl_ch_prz, 
                                                    0 AS vl_ch_vst, 0 AS vl_blt, 
                                                    0 AS vl_out, 
                                                    count(*) AS qtd_cli
                                                   FROM tb_vnd
                                              LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
                                         LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
                                        GROUP BY tb_vnd.id_emp, tb_vnd.dt_vnd, tb_part.id_rota, tb_vnd.id_vndr, tb_rota.descr
                                        UNION ALL 
                                                 SELECT tb_vnd.id_emp, 
                                                    tb_vnd.dt_vnd, 
                                                        CASE date_part('dow'::text, tb_vnd.dt_vnd)
                                                            WHEN 0 THEN 'Domingo'::text
                                                            WHEN 1 THEN 'Segunda'::text
                                                            WHEN 2 THEN 'Tera'::text
                                                            WHEN 3 THEN 'Quarta'::text
                                                            WHEN 4 THEN 'Quinta'::text
                                                            WHEN 5 THEN 'Sexta'::text
                                                            WHEN 6 THEN 'Sabado'::text
                                                            ELSE NULL::text
                                                        END AS dia_semana, 
                                                    tb_part.id_rota, 
                                                    tb_vnd.id_vndr, 
                                                    tb_rota.descr, 
                                                    sum(tb_vnd_parc.vl_parc) AS vl_cred, 
                                                    0 AS vl_ch_prz, 
                                                    0 AS vl_ch_vst, 0 AS vl_blt, 
                                                    0 AS vl_out, 0 AS qtd_cli
                                                   FROM tb_vnd
                                              LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
                                         LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
                                    LEFT JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd
                               JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
                              WHERE tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd AND COALESCE(tb_vnd.tp_vnd, 'V'::character varying)::text = 'V'::text AND COALESCE(tb_vnd.canc, false) = false AND tb_op_fnc.tp_op_fnc::text = 'DUP'::text
                              GROUP BY tb_vnd.id_emp, tb_vnd.dt_vnd, tb_part.id_rota, tb_vnd.id_vndr, tb_rota.descr)
                                UNION ALL 
                                         SELECT tb_vnd.id_emp, tb_vnd.dt_vnd, 
                                                CASE date_part('dow'::text, tb_vnd.dt_vnd)
                                                    WHEN 0 THEN 'Domingo'::text
                                                    WHEN 1 THEN 'Segunda'::text
                                                    WHEN 2 THEN 'Tera'::text
                                                    WHEN 3 THEN 'Quarta'::text
                                                    WHEN 4 THEN 'Quinta'::text
                                                    WHEN 5 THEN 'Sexta'::text
                                                    WHEN 6 THEN 'Sabado'::text
                                                    ELSE NULL::text
                                                END AS dia_semana, 
                                            tb_part.id_rota, tb_vnd.id_vndr, 
                                            tb_rota.descr, 0 AS vl_cred, 
                                            sum(tb_vnd_parc.vl_parc) AS vl_ch_prz, 
                                            0 AS vl_ch_vst, 0 AS vl_blt, 
                                            0 AS vl_out, 0 AS qtd_cli
                                           FROM tb_vnd
                                      LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
                                 LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
                            LEFT JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd
                       JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
                      WHERE tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd AND COALESCE(tb_vnd.tp_vnd, 'V'::character varying)::text = 'V'::text AND COALESCE(tb_vnd.canc, false) = false AND tb_op_fnc.tp_op_fnc::text = 'CH_PRZ'::text
                      GROUP BY tb_vnd.id_emp, tb_vnd.dt_vnd, tb_part.id_rota, tb_vnd.id_vndr, tb_rota.descr)
                        UNION ALL 
                                 SELECT tb_vnd.id_emp, tb_vnd.dt_vnd, 
                                        CASE date_part('dow'::text, tb_vnd.dt_vnd)
                                            WHEN 0 THEN 'Domingo'::text
                                            WHEN 1 THEN 'Segunda'::text
                                            WHEN 2 THEN 'Tera'::text
                                            WHEN 3 THEN 'Quarta'::text
                                            WHEN 4 THEN 'Quinta'::text
                                            WHEN 5 THEN 'Sexta'::text
                                            WHEN 6 THEN 'Sabado'::text
                                            ELSE NULL::text
                                        END AS dia_semana, 
                                    tb_part.id_rota, tb_vnd.id_vndr, 
                                    tb_rota.descr, 0 AS vl_cred, 0 AS vl_ch_prz, 
                                    sum(tb_vnd_parc.vl_parc) AS vl_ch_vst, 
                                    0 AS vl_blt, 0 AS vl_out, 0 AS qtd_cli
                                   FROM tb_vnd
                              LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
                         LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
                    LEFT JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd
               JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
              WHERE tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd AND COALESCE(tb_vnd.tp_vnd, 'V'::character varying)::text = 'V'::text AND COALESCE(tb_vnd.canc, false) = false AND tb_op_fnc.tp_op_fnc::text = 'CH'::text
              GROUP BY tb_vnd.id_emp, tb_vnd.dt_vnd, tb_part.id_rota, tb_vnd.id_vndr, tb_rota.descr)
                UNION ALL 
                         SELECT tb_vnd.id_emp, tb_vnd.dt_vnd, 
                                CASE date_part('dow'::text, tb_vnd.dt_vnd)
                                    WHEN 0 THEN 'Domingo'::text
                                    WHEN 1 THEN 'Segunda'::text
                                    WHEN 2 THEN 'Tera'::text
                                    WHEN 3 THEN 'Quarta'::text
                                    WHEN 4 THEN 'Quinta'::text
                                    WHEN 5 THEN 'Sexta'::text
                                    WHEN 6 THEN 'Sabado'::text
                                    ELSE NULL::text
                                END AS dia_semana, 
                            tb_part.id_rota, tb_vnd.id_vndr, tb_rota.descr, 
                            0 AS vl_cred, 0 AS vl_ch_prz, 0 AS vl_ch_vst, 
                            sum(tb_vnd_parc.vl_parc) AS vl_blt, 0 AS vl_out, 
                            0 AS qtd_cli
                           FROM tb_vnd
                      LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
                 LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
            LEFT JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd
       JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
      WHERE tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd AND COALESCE(tb_vnd.tp_vnd, 'V'::character varying)::text = 'V'::text AND COALESCE(tb_vnd.canc, false) = false AND tb_op_fnc.tp_op_fnc::text = 'BLT'::text
      GROUP BY tb_vnd.id_emp, tb_vnd.dt_vnd, tb_part.id_rota, tb_vnd.id_vndr, tb_rota.descr)
        UNION ALL 
                 SELECT tb_vnd.id_emp, tb_vnd.dt_vnd, 
                        CASE date_part('dow'::text, tb_vnd.dt_vnd)
                            WHEN 0 THEN 'Domingo'::text
                            WHEN 1 THEN 'Segunda'::text
                            WHEN 2 THEN 'Tera'::text
                            WHEN 3 THEN 'Quarta'::text
                            WHEN 4 THEN 'Quinta'::text
                            WHEN 5 THEN 'Sexta'::text
                            WHEN 6 THEN 'Sabado'::text
                            ELSE NULL::text
                        END AS dia_semana, 
                    tb_part.id_rota, tb_vnd.id_vndr, tb_rota.descr, 
                    0 AS vl_cred, 0 AS vl_ch_prz, 0 AS vl_ch_vst, 0 AS vl_blt, 
                    sum(tb_vnd_parc.vl_parc) AS vl_out, 0 AS qtd_cli
                   FROM tb_vnd
              LEFT JOIN tb_part ON tb_vnd.id_cli = tb_part.id_part
         LEFT JOIN tb_rota ON tb_part.id_rota = tb_rota.id_rota
    LEFT JOIN tb_vnd_parc ON tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd
   JOIN tb_op_fnc ON tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc
  WHERE tb_vnd.id_emp = tb_vnd_parc.id_emp AND tb_vnd.id_vnd = tb_vnd_parc.id_vnd AND COALESCE(tb_vnd.tp_vnd, 'V'::character varying)::text = 'V'::text AND COALESCE(tb_vnd.canc, false) = false AND (tb_op_fnc.tp_op_fnc::text <> ALL (ARRAY['DUP'::text, 'CH'::text, 'CH'::text, 'BLT'::text, 'CH_PRZ'::text]))
  GROUP BY tb_vnd.id_emp, tb_vnd.dt_vnd, tb_part.id_rota, tb_vnd.id_vndr, tb_rota.descr) tb
  GROUP BY tb.id_emp, tb.dt_vnd, tb.id_vndr, tb.dia_semana, tb.id_rota, tb.descr
  ORDER BY tb.dt_vnd;

ALTER TABLE public.tb_part
  ADD CONSTRAINT fk__part__resp FOREIGN KEY (id_resp)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;
