
-- ALTER TABLE public.tb_log
--   DROP CONSTRAINT fk__log__est RESTRICT;

CREATE OR REPLACE FUNCTION public.fc_gera_sinc (
  _dt date = 'now'::text::date
)
RETURNS boolean AS
$body$
declare
    _list refcursor;
    _item record;
    _command varchar;
begin
    open _list for
        select 
            pg_tables.tablename,
            array(select cast(pg_attribute.attname as varchar)
                  from pg_attribute
                  where 
                       pg_attribute.attrelid = cast(pg_tables.tablename as pg_catalog.regclass) and
                       not pg_attribute.attisdropped) as cols
        from pg_tables
        where
            pg_tables.schemaname = 'public';
            
    fetch _list into _item;
    
    while found loop
    
        if (_item.cols @> array[cast('dt_hr_ult_alt' as varchar)]) then

            execute 'update ' || _item.tablename || ' set dt_hr_ult_alt = dt_hr_ult_alt where cast(dt_hr_ult_alt as date) >= ' || quote_literal(cast(_dt as varchar));
            
        end if;
    
        fetch _list into _item;
        
    end loop;
    
    
    return true;        
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

-- object recreation
DROP FUNCTION public.fc_init_est(_id_est integer, _upd_id boolean);

CREATE FUNCTION public.fc_init_est (
  _id_est integer,
  _upd_id boolean = false
)
RETURNS boolean AS
$body$
declare
    _seq_list refcursor;
    _seq record;
    _est record;
    _id_init integer;
    _cmd varchar;
    _tab record;
    _max_id integer;
begin
    select * into _est
    from tb_est
    where
        id_est = _id_est;
        
    perform fc_en_trg(false, false);

    open _seq_list for
        select * 
        from pg_class 
        join pg_tables on
            (replace(pg_class.relname, 'sq_', 'tb_') = pg_tables.tablename and
             pg_tables.schemaname = 'public')
        where
            relkind = 'S';
            
    fetch _seq_list into _seq;
    
    while found loop
        select tb_sinc_def_item.* into _tab
        from tb_sinc_def
        join tb_sinc_def_item on
            (tb_sinc_def.id_sinc_def = tb_sinc_def_item.id_sinc_def and
             tb_sinc_def_item.env)
        where
            tb_sinc_def_item.tb = replace(_seq.relname, 'sq_', 'tb_');
        
        if (found) then
        
            _id_init := _est.seq_inc + _est.id_est;
            
            raise notice '% %', _seq.relname, _id_init;
            
            execute 
                ' select max(' || replace(_seq.relname, 'sq_', 'id_') || ') ' ||
                ' from ' || _tab.tb ||
                ' where mod(' || replace(_seq.relname, 'sq_', 'id_') || ',' || _est.seq_inc || ') = ' || _est.id_est  
                into _max_id;
            
            if (_max_id is null) then
                _max_id := _id_init;
            else
                _max_id := _max_id + _est.seq_inc;
            end if;
            
            
            _cmd := 'alter sequence ' || _seq.relname || ' increment by ' || _est.seq_inc || ' restart with ' || _max_id;
            
            raise notice '%', _cmd;
            
            execute _cmd;
            
            if (_upd_id is null) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = ' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' / ' || 
                    _est.seq_inc;
                
                raise notice '%', _cmd;
                
                execute _cmd;
            elsif (_upd_id) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = (' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' * ' || 
                    _est.seq_inc || ') + ' || _est.id_est;
                
                raise notice '%', _cmd;
                
                execute _cmd;
            end if;
        else 
            
            execute ' select max(' || replace(_seq.relname, 'sq_', 'id_') || ') +1 ' || ' from ' || replace(_seq.relname, 'sq_', 'tb_') into _max_id;
            
            raise notice '% %', _seq.relname, coalesce(_max_id, '1');
            
            _cmd := 'alter sequence ' || _seq.relname || ' increment by 1 restart with ' || coalesce(_max_id, '1');

            raise notice '%', _cmd;
            
            execute _cmd;
        
        end if;
    
        fetch _seq_list into _seq;
    end loop;
    
    update tb_est set
        local = false;
    
    update tb_est set
        local = true
    where
        id_est = _id_est;
    
    perform fc_en_trg(true, false);
    
    
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

-- DROP TABLE public.tb_log;

