CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name,
  _install boolean
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
    _pk varchar[];
    _log_tab boolean;
begin
    delete from tb_sis_uni
    where
        tab = _tab;
        
    select _tab not in (
        'tb_sis_uni',
        'tb_log',
        'tb_log_con',
        'tb_sinc',
        'tb_sinc_stat',
        'tb_item_estq',
        'tb_script',
        'tb_sis_atu',
        'tb_emp_cnf'
    ) into _log_tab;


    if (_log_tab and _install) then
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        execute 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log after insert or update or delete ' ||
            ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';

        perform fc_add_col('public.' || _tab, 'dt_hr_ult_alt', 'timestamp');
        
        select
            array(
                select 
                    cast(c.column_name as varchar)
                from information_schema.table_constraints tc
                join information_schema.constraint_column_usage as ccu using 
                    (constraint_schema, constraint_name)
                join information_schema.columns as c on 
                    (c.table_schema = tc.constraint_schema and 
                     tc.table_name = c.table_name and 
                     ccu.column_name = c.column_name)
                where 
                    constraint_type = 'PRIMARY KEY' and
                    tc.table_name = _tab
                )
        into _pk;
        
        raise notice 'Tabela: %', _tab;
        
        insert into tb_sis_uni
            (tab, pk)
        values
            (_tab, _pk);
        
        
        return true;
    else 
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_item_emp_bf (
)
RETURNS trigger AS
$body$
declare
    _id_emp_matriz integer;
    _cnf_item_alt_prc_filial varchar;
    
    _filial record;
    _app_con varchar;
begin
    _app_con := fc_app_con();
    
    if (_app_con = 'NEO_UNI') then
        return new;
    end if;

    if (tg_op = 'INSERT') 
        or (tg_op = 'UPDATE'
            and (old.vl_cst_med <> new.vl_cst_med
                 or old.vl_cst_rep <> new.vl_cst_rep
                 or old.vl_prc_vnd <> new.vl_prc_vnd)) then
        --
        -- Altera/Insere os preos nas filiais
        --
        _cnf_item_alt_prc_filial := fc_get_emp_cnf(new.id_emp, 07011);
        
        if (lower(_cnf_item_alt_prc_filial) = 'true') then
            _id_emp_matriz := fc_id_emp_matriz();
            if (new.id_emp = _id_emp_matriz) then
                
                for _filial in
                    select id_part
                    from tb_part
                    where
                        tp_part like '%[E]%' and
                        id_part <> new.id_emp
                loop
                    update tb_item_emp set
                        vl_cst_med = new.vl_cst_med,
                        vl_cst_rep = new.vl_cst_rep,
                        vl_ult_cst_med = new.vl_ult_cst_med,
                        dt_ult_cmp = new.dt_ult_cmp,
                        vl_prc_vnd = new.vl_prc_vnd,
                        vl_estq_min = new.vl_estq_min,
                        vl_estq_max = new.vl_estq_max,
                        ender_estq = new.ender_estq,
                        vl_perc_luc = new.vl_perc_luc,
                        vl_out = new.vl_out,
                        vl_perc_desp_op = new.vl_perc_desp_op,
                        vl_desp_op = new.vl_desp_op,
                        vl_luc = new.vl_luc,
                        vl_ult_prc_vnd = new.vl_ult_prc_vnd,
                        vl_ult_cst_rep = new.vl_ult_cst_rep,
                        dt_hr_ult_alt = new.dt_hr_ult_alt
                    where
                        id_item = new.id_item and
                        id_emp = _filial.id_part;
                        
                    if not found then
                        insert into tb_item_emp 
                            (id_item, id_emp, vl_cst_med, vl_cst_rep, vl_ult_cst_med, dt_ult_cmp,
                             vl_prc_vnd, vl_estq_min, vl_estq_max, ender_estq, vl_perc_luc, vl_out,
                             vl_perc_desp_op, vl_desp_op, vl_luc, vl_ult_prc_vnd, vl_ult_cst_rep,
                             dt_hr_ult_alt)
                        values
                            (new.id_item, _filial.id_part, new.vl_cst_med, new.vl_cst_rep, new.vl_ult_cst_med, new.dt_ult_cmp,
                             new.vl_prc_vnd, new.vl_estq_min, new.vl_estq_max, new.ender_estq, new.vl_perc_luc, new.vl_out,
                             new.vl_perc_desp_op, new.vl_desp_op, new.vl_luc, new.vl_ult_prc_vnd, new.vl_ult_cst_rep,
                             new.dt_hr_ult_alt);
                    end if;
                end loop;
                
            end if;
        end if;
    end if;



    if (tg_op = 'UPDATE') then
        if (old.vl_cst_med <> new.vl_cst_med or
            old.vl_cst_rep <> new.vl_cst_rep or
            old.vl_prc_vnd <> new.vl_prc_vnd) then

            insert into tb_item_alt_prc
                (id_emp, id_item_alt_prc, id_item, dt_hr, 
                 vl_cst_rep_ant, vl_cst_rep_atu, 
                 vl_cst_med_ant, vl_cst_med_atu, 
                 vl_prc_vnd_ant, vl_prc_vnd_atu)
            values 
                (new.id_emp, nextval('sq_item_alt_prc'), new.id_item, current_timestamp,
                 old.vl_cst_rep, new.vl_cst_rep,
                 old.vl_cst_med, new.vl_cst_med,
                 old.vl_prc_vnd, new.vl_prc_vnd);

        end if;
    end if;
    
    return new;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;