CREATE OR REPLACE FUNCTION public.fc_limpa_db (
)
RETURNS boolean AS
$body$
declare
    _list refcursor;
    _item record;
begin
    perform fc_en_trg(false, true);
    
    open _list for
        select pg_tables.tablename
        from pg_tables
        where
            pg_tables.schemaname = 'public';
    
    fetch _list into _item;
    
    while (found) loop
        if (_item.tablename not in ('tb_part', 'tb_munic', 'tb_bairro', 'tb_bnc', 'tb_cfop',
            'tb_cnae', 'tb_cond_pagto', 'tb_cond_pagto_parc', 'tb_conv', 'tb_cx', 'tb_dep', 
            'tb_emp_cnf', 'tb_est', 'tb_est_cnf', 'tb_etq', 'tb_etq_cmp', 'tb_grd_estq', 
            'tb_grp_cfop', 'tb_grp_cfop_nat_op', 'tb_grp_trib', 'tb_grp_trib_nat_op',
            'tb_grp_usr', 'tb_grp_usr_op', 'tb_logr', 'tb_mod_frete', 'tb_mod_nf',
            'tb_mtv_dev_ch', 'tb_nat_op', 'tb_ncm', 'tb_op_fnc', 'tb_org_icms', 'tb_plano_ct', 'tb_prio_os',
            'tb_prod_anp', 'tb_reg_trib', 'tb_rel', 'tb_rel_cab', 'tb_rel_col', 'tb_rel_item',
            'tb_rel_item_col', 'tb_rel_item_tot', 'tb_script', 'tb_serv', 'tb_sis_grid', 'tb_sis_lay',
            'tb_sis_valid', 'tb_tp_item', 'tb_trib_cofins', 'tb_trib_icms', 'tb_trib_ipi', 'tb_trib_pis',
            'tb_uf', 'tb_und_med', 'tb_usr', 'tb_usr__grp_usr', 'tb_usr__emp')) then
            
            execute 'delete from "' || _item.tablename || '"';
        end if;
            
    
        fetch _list into _item;
    end loop;
    
    
    delete from "tb_part" where tp_part not like '%[E]%' or tp_part is null;
    
    delete from tb_usr
    where 
        not exists (
            select 1
            from tb_usr__grp_usr 
            join tb_grp_usr using 
                (id_grp_usr)
            where
                tb_usr__grp_usr.id_usr = tb_usr.id_usr
                and tb_grp_usr.adm);
    
    
    perform fc_en_trg(true, true);
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

