CREATE OR REPLACE FUNCTION public.fc_vnd_ident_sit (
  _id_emp integer,
  _id_ident integer,
  _id_sit_vnd varchar
)
RETURNS boolean AS
$body$
begin
    if exists(select 1 
              from tb_vnd_ident_sit 
              where 
                  id_emp = _id_emp 
                  and id_ident = _id_ident) 
    then
        update tb_vnd_ident_sit set
            id_sit_vnd = _id_sit_vnd
        where
            id_emp = _id_emp 
            and id_ident = _id_ident;
    else
        insert into tb_vnd_ident_sit
            (id_emp, id_ident, id_sit_vnd)
        values
            (_id_emp, _id_ident, _id_sit_vnd);
    end if;
        
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _id_cli_cons varchar;
begin
    _app_con := fc_app_con();

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
    
        if (new.org = 'CONSIG') then
            update tb_consig set
                sit = 'F'
            where
                id_emp = new.id_emp and
                id_consig = new.id_org;
        end if;
        
        _id_cli_cons := fc_get_emp_cnf(new.id_emp, 01000);
        
        if (cast(new.id_cli as varchar) <> _id_cli_cons) then
            
            update tb_part set
                id_cond_pagto = new.id_cond_pagto,
                id_fm_pagto = new.id_fm_pagto
            where
                id_part = new.id_cli;
                
        end if;
        
        if (new.id_sit_vnd is not null and new.cd_ref is not null) then
            perform fc_vnd_ident_sit(new.id_emp, cast(new.cd_ref as integer), new.id_sit_vnd);
        end if;
            
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        
        if (old.org = 'CONSIG') then
            update tb_consig set
                sit = 'D'
            where
                id_emp = old.id_emp and
                id_consig = old.id_org;
        end if;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org like 'VND.' || old.id_vnd || '%';
    
    end if;
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_sit_vnd (
  id_sit_vnd VARCHAR(10) NOT NULL, 
  descr VARCHAR(100), 
  cor VARCHAR(10), 
  ord INTEGER, 
  sit VARCHAR(1), 
  CONSTRAINT pk_sit_vnd PRIMARY KEY(id_sit_vnd)
) ;

ALTER TABLE public.tb_vnd
  ADD COLUMN id_sit_vnd VARCHAR(10);

CREATE TABLE public.tb_vnd_ident_sit (
  id_emp INTEGER NOT NULL, 
  id_ident INTEGER NOT NULL, 
  id_sit_vnd VARCHAR(10), 
  CONSTRAINT pk_vnd_ident_sit PRIMARY KEY(id_emp, id_ident)
) ;

ALTER TABLE public.tb_vnd_ident_sit
  ADD CONSTRAINT fk__vnd_ident_sit__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd_ident_sit
  ADD CONSTRAINT fk__vnd_ident_sit__sit_vnd FOREIGN KEY (id_sit_vnd)
    REFERENCES public.tb_sit_vnd(id_sit_vnd)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd
  ADD CONSTRAINT fk__vnd__sit_vnd FOREIGN KEY (id_sit_vnd)
    REFERENCES public.tb_sit_vnd(id_sit_vnd)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_sit_vnd
  OWNER TO postgres;

ALTER TABLE public.tb_vnd_ident_sit
  OWNER TO postgres;

