CREATE OR REPLACE FUNCTION public.fc_tr_part_contr_af (
)
RETURNS trigger AS
$body$
declare
    _qtd integer;
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    _op_fnc record;
begin
    select count(*) into _qtd
    from tb_ct
    where
        id_emp = new.id_emp and
        id_part = new.id_part and
        tp_ct = 'R' and
        org = 'CONTR.' || new.id_part || '.' || new.id_part_contr;
        
    if (_qtd = 0) then
        
        _id_cnt_bnc := null;
        
        if (new.tp_doc = 'BLT') then
            _id_cnt_bnc_str := fc_get_emp_cnf(new.id_emp, 01002);
            if (_id_cnt_bnc_str <> '') then
                _id_cnt_bnc := cast(_id_cnt_bnc_str as integer);
            end if;
        end if;
        
        select * into _op_fnc
        from tb_op_fnc
        where
            tp_op_fnc = new.doc
        order by
            id_op_fnc
        limit 1;
        
        
        insert into tb_ct
            (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, dt_emis, dt_venc,
             vl_ct, obs, stat, tp_doc, org, id_cnt_bnc, id_op_fnc, 
             vl_quit, vl_rest)
        values
            (new.id_emp, nextval('sq_ct'), 'R', new.id_part, new.doc, 1, 1, new.dt_i, fc_calc_venc(new.dt_i, new.tp_interv, new.interv),
             new.vl_contr, new.obs, 'P', new.tp_doc, 'CONTR.' || new.id_part || '.' || new.id_part_contr, _id_cnt_bnc, _op_fnc.id_op_fnc,
             0, new.vl_contr);
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;