CREATE SEQUENCE public.sq_lib_op
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE TABLE public.tb_grp_usr_op (
  id_grp_usr INTEGER NOT NULL, 
  id_op INTEGER NOT NULL, 
  val TEXT
) WITHOUT OIDS;

CREATE TABLE public.tb_lib_op (
  id_emp INTEGER NOT NULL, 
  id_lib_op INTEGER NOT NULL, 
  id_usr INTEGER, 
  dt_hr TIMESTAMP WITHOUT TIME ZONE, 
  descr VARCHAR(255), 
  det TEXT, 
  sit VARCHAR(1), 
  descr_sit VARCHAR(255), 
  id_usr_sit INTEGER
) WITHOUT OIDS;

ALTER TABLE public.tb_lib_op
  ADD CONSTRAINT pk_lib_op 
    PRIMARY KEY (id_emp, id_lib_op);

ALTER TABLE public.tb_grp_usr_op
  ADD CONSTRAINT pk_grp_usr_op 
    PRIMARY KEY (id_grp_usr, id_op);

ALTER TABLE public.tb_lib_op
  ADD CONSTRAINT fk__lib_op__usr_sit FOREIGN KEY (id_usr_sit)
    REFERENCES public.tb_usr(id_usr)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_lib_op
  ADD CONSTRAINT fk__lib_op__usr FOREIGN KEY (id_usr)
    REFERENCES public.tb_usr(id_usr)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_lib_op
  ADD CONSTRAINT fk__lib_op__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_grp_usr_op
  ADD CONSTRAINT fk__grp_usr_op__grp_usr FOREIGN KEY (id_grp_usr)
    REFERENCES public.tb_grp_usr(id_grp_usr)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

