CREATE OR REPLACE FUNCTION public.fc_gera_mov_fnc (
  _id_emp integer,
  _id_cx integer,
  _id_usr integer,
  _dt_lanc date,
  _hr_lanc time,
  _descr varchar,
  _op varchar,
  _vl_lanc numeric,
  _org varchar,
  _id_org integer,
  _id_op_fnc integer
)
RETURNS bigint AS
$body$
declare
    _mov_fnc record;
    _id_mov_fnc bigint;
    _op_fnc record;
begin
    select * into _op_fnc
    from tb_op_fnc
    where
        id_op_fnc = _id_op_fnc;
        
    if (coalesce(_op_fnc.mov_cx, true) = false) then
        return 0;
    end if;

    select * into _mov_fnc
    from tb_mov_fnc
    where
        id_emp = _id_emp and
        op = _op and
        org = _org and
        id_org = _id_org;
    
    if found then
        delete from tb_mov_fnc
        where
            id_emp = _id_emp and
            id_mov_fnc = _mov_fnc.id_mov_fnc;
    end if;
    
    _id_mov_fnc := nextval('sq_mov_fnc');
        
    insert into tb_mov_fnc 
        (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc,
         descr, op, vl_lanc, org, id_org, id_op_fnc)
    values
        (_id_emp, _id_mov_fnc, _id_cx, _id_usr, _dt_lanc, substring(cast(_hr_lanc as varchar), 1, 8)::time, 
         _descr || cast(current_time as varchar), _op, _vl_lanc, _org, _id_org, _id_op_fnc);
    
    return _id_mov_fnc;    
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;