CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name,
  _install boolean
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
begin
    --tb_emp_cnf
    
    /*
    if (_tab in ('tb_bairro', 'tb_blt', 'tb_blt_ret', 'tb_bnc', 'tb_bnc_blt', 'tb_bx_ct', 
        'tb_cfop', 'tb_ch', 'tb_cnae', 'tb_cnt_bnc', 'tb_cond_pagto', 'tb_conv',
        'tb_ct', 'tb_cx', 'tb_dep', 'tb_emis_blt', 'tb_grd_estq', 
        'tb_grp_cfop', 'tb_grp_item', 'tb_grp_trib', 'tb_grp_usr', 'tb_item',
        'tb_logr', 'tb_marca', 'tb_mnt_estq', 'tb_mod_frete', 'tb_mod_nf', 
        'tb_mov_cx', 'tb_mov_fnc', 'tb_mtv_dev_ch', 'tb_munic', 'tb_nat_op', 
        'tb_ncm', 'tb_nf', 'tb_nfe_dest', 'tb_obj_os', 'tb_op_fnc', 'tb_org_icms', 
        'tb_os', 'tb_part', 'tb_ped', 'tb_prio_os', 'tb_prod_anp', 'tb_reg_trib',
        'tb_rel', 'tb_script', 'tb_serv', 'tb_sis_grid', 'tb_sis_valid', 'tb_tp_item',
        'tb_trib_cofins', 'tb_trib_icms', 'tb_trib_ipi', 'tb_trib_pis', 'tb_uf',
        'tb_und_med', 'tb_usr', 'tb_vnd')
    ) */
    if (_tab not in ('tb_log', 'tb_log_con', 'tb_item_estq', 'tb_lic', 'tb_script') and _install) then
    
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;

        _cmd := 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log ';
        
        if (_tab = 'tb_est') then
            _cmd := _cmd || ' after insert or delete ';
        else
            _cmd := _cmd || ' after insert or update or delete ';
        end if;
        
        _cmd := _cmd || ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';
            
        execute _cmd;
        
        perform fc_add_col('public.' || _tab, 'dt_hr_ult_alt', 'timestamp');
            
        return true;
        
    else 
        -- raise notice '%', replace(_tab, 'tb_', 'tr_');
        
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_rel
  ADD COLUMN imp_cab BOOLEAN;

ALTER TABLE public.tb_rel
  ALTER COLUMN imp_cab SET DEFAULT true;

ALTER TABLE public.tb_rel
  ADD COLUMN imp_rod BOOLEAN;

ALTER TABLE public.tb_rel
  ALTER COLUMN imp_rod SET DEFAULT true;

