CREATE SEQUENCE public.sq_cce
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_cce RESTART WITH 8;

CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name,
  _install boolean
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
begin
    --tb_emp_cnf
    
    /*
    if (_tab in ('tb_bairro', 'tb_blt', 'tb_blt_ret', 'tb_bnc', 'tb_bnc_blt', 'tb_bx_ct', 
        'tb_cfop', 'tb_ch', 'tb_cnae', 'tb_cnt_bnc', 'tb_cond_pagto', 'tb_conv',
        'tb_ct', 'tb_cx', 'tb_dep', 'tb_emis_blt', 'tb_grd_estq', 
        'tb_grp_cfop', 'tb_grp_item', 'tb_grp_trib', 'tb_grp_usr', 'tb_item',
        'tb_logr', 'tb_marca', 'tb_mnt_estq', 'tb_mod_frete', 'tb_mod_nf', 
        'tb_mov_cx', 'tb_mov_fnc', 'tb_mtv_dev_ch', 'tb_munic', 'tb_nat_op', 
        'tb_ncm', 'tb_nf', 'tb_nfe_dest', 'tb_obj_os', 'tb_op_fnc', 'tb_org_icms', 
        'tb_os', 'tb_part', 'tb_ped', 'tb_prio_os', 'tb_prod_anp', 'tb_reg_trib',
        'tb_rel', 'tb_script', 'tb_serv', 'tb_sis_grid', 'tb_sis_valid', 'tb_tp_item',
        'tb_trib_cofins', 'tb_trib_icms', 'tb_trib_ipi', 'tb_trib_pis', 'tb_uf',
        'tb_und_med', 'tb_usr', 'tb_vnd')
    ) */
    if (_tab not in ('tb_log', 'tb_log_con', 'tb_item_estq', 'tb_lic') and _install) then
    
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;

        _cmd := 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log ';
        
        if (_tab = 'tb_est') then
            _cmd := _cmd || ' after insert or delete ';
        else
            _cmd := _cmd || ' after insert or update or delete ';
        end if;
        
        _cmd := _cmd || ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';
        
        execute _cmd;
            
        return true;
        
    else 
        -- raise notice '%', replace(_tab, 'tb_', 'tr_');
        
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_log_af (
)
RETURNS trigger AS
$body$
declare
    _est_list refcursor;
    _est record;
    _id_est_con integer;
    _tab record;
begin
    
    select 
        tablename, 
        case
            when tablename in ('tb_bairro', 'tb_bnc', 'tb_bnc_blt', 'tb_cfop', 'tb_cnae', 'tb_cnt_bnc',
                'tb_cond_pagto', 'tb_cond_pagto_parc', 'tb_conv', 'tb_cx', 'tb_dep', 'tb_est', 'tb_grd_estq', 
                'tb_grp_cfop', 'tb_grp_cfop_nat_op', 'tb_grp_item', 'tb_grp_trib', 'tb_grp_trib_nat_op', 
                'tb_grp_usr', 'tb_logr', 'tb_marca', 'tb_mod_frete', 'tb_mod_nf', 'tb_mtv_dev_ch', 'tb_munic', 
                'tb_nat_op', 'tb_ncm', 'tb_obj_os', 'tb_op_fnc', 'tb_org_icms', 'tb_prio_os', 'tb_prod_anp',
                'tb_reg_trib', 'tb_rel', 'tb_rel_cab', 'tb_rel_col', 'tb_rel_item', 'tb_rel_item_col', 
                'tb_rel_item_tot', 'tb_rel_tot', 'tb_rota', 'tb_serv', 'tb_sis_grid', 'tb_sis_lay', 
                'tb_sis_valid', 'tb_tp_item', 'tb_trib_cofins',
                'tb_trib_icms', 'tb_trib_ipi', 'tb_trib_pis', 'tb_uf', 'tb_und_med', 
                'tb_usr', 'tb_usr__grp_usr') 
                then 'R1'
            when tablename in ('tb_part', 'tb_part_cond_pagto', 'tb_part_cred', 'tb_part_ender', 'tb_part_obs',
                'tb_part_op_fnc', 'tb_part_ref',
                'tb_item', 'tb_item_cd_bar', 'tb_item_emp', 'tb_item_forn', 'tb_item_und_med')
                then 'R2'
            when tablename in ('tb_emp_cnf', 'tb_item_estq', 'tb_item_prc_vnd_log', 'tb_script', 'tb_lic') 
                then 'N'
            else 'E'
        end as op
    into _tab
    from pg_tables
    where
        tablename = new.org;
    
    
    if (new.id_est is null or (new.id_est <> fc_id_est_local() and new.id_est <> fc_id_est_central() )) and (new.sit is null) and 
        ( (_tab.op in ('R1', 'E') and fc_id_est_local() = fc_id_est_central()) or (_tab.op in ('E', 'R2')) )
    then
        
        _id_est_con := fc_id_est_con();
        
        
        if (fc_id_est_local() <> fc_id_est_central()) then
            open _est_list for
                select *
                from tb_est
                where
                    tb_est.tp_est = 'C';
                    
        elsif (_id_est_con is null) and (_tab.op = 'R2') then
            open _est_list for
                select *
                from tb_est
                where
                    not tb_est.local;
        elsif (_tab.op = 'R1') then
            open _est_list for
                select *
                from tb_est
                where
                    not tb_est.local and
                    tb_est.id_est <> _id_est_con;
        else 
            return null;
        end if;
        
        fetch _est_list into _est;
        
        while found loop
        
            insert into tb_log
                (id_log, org, op, col_pk, val_pk, id_est, dt_hr, sit)
            values
                (nextval('sq_log'), new.org, new.op, new.col_pk, new.val_pk, _est.id_est, new.dt_hr, 'P');
            
            fetch _est_list into _est;
        
        end loop;
    end if;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_cce (
  id_emp INTEGER NOT NULL, 
  id_cce INTEGER NOT NULL, 
  ch_nfe VARCHAR(50), 
  dt_cce DATE, 
  hr_cce TIME WITHOUT TIME ZONE, 
  corr TEXT, 
  sit VARCHAR(1), 
  id_sit INTEGER, 
  descr_sit VARCHAR(255), 
  nr_prot VARCHAR(20), 
  xml TEXT, 
  seq INTEGER
) WITHOUT OIDS;

CREATE TABLE public.tb_lic (
  lic BYTEA
) WITHOUT OIDS;

ALTER TABLE public.tb_cce
  ADD CONSTRAINT pk_cce 
    PRIMARY KEY (id_emp, id_cce);

ALTER TABLE public.tb_cce
  ADD CONSTRAINT fk__cce__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

