ALTER TABLE public.tb_nf_item
  DROP CONSTRAINT fk__nf_item__ncm RESTRICT;

CREATE OR REPLACE FUNCTION public.fc_sit_ch (
  _id_emp integer,
  _id_ch integer,
  _sit varchar,
  _obs varchar,
  _dt date,
  _id_cnt_bnc integer
)
RETURNS boolean AS
$body$
declare
    _id_ch_sit integer;
begin
    select coalesce(max(id_ch_sit), 0) + 1 into _id_ch_sit
    from tb_ch_sit
    where
        id_emp = _id_emp and
        id_ch = _id_ch;
    
    insert into tb_ch_sit 
        (id_emp, id_ch, id_ch_sit, dt_sit, sit, obs)
    values
        (_id_emp, _id_ch, _id_ch_sit, current_date, _sit, _obs);
        
    if (_id_cnt_bnc is not null) then
        update tb_ch set
            id_cnt_bnc = _id_cnt_bnc
        where
            id_emp = _id_emp and
            id_ch = _id_ch;
    end if;
    
    update tb_ch set
        dt_sit = _dt,
        sit = _sit,
        obs = _obs
    where
        id_emp = _id_emp and
        id_ch = _id_ch;
        
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_bx_ct = old.id_bx_ct and
            id_bx_ct_pagto = old.id_bx_ct_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
            _id_ch := nextval('sq_ch');
                
            insert into tb_ch
                (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                 dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_bx_ct, id_bx_ct_pagto)
            values
                (new.id_emp, _id_ch, ifthen(_bx_ct.tp_bx = 'R', 'R', 'E'), _bx_ct.id_part, new.emit, new.cpf_cnpj,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_bx_ct, new.id_bx_ct_pagto);
                
            perform fc_sit_ch(new.id_emp, _id_ch, 'P', 'QUITACAO DE DUPLICATA ' || _bx_ct.id_bx_ct, _bx_ct.dt_bx, null);
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_ch_bf (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (old.tp_ch = 'E') then
        delete from tb_mov_bnc
        where
            id_emp = old.id_emp and
            org = 'ch' and
            id_org = old.id_ch;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        if (new.tp_ch = 'E') then

            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr, 'D', new.vl_ch, new.obs, false, 'ch', new.id_ch, new.id_part);

        elseif (tg_op = 'UPDATE' and old.sit <> 'DEP' and new.sit = 'DEP') then

            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_sit, new.dt_sit, new.nr, 'C', new.vl_ch, 'DEPOSITO', false, 'ch', new.id_ch, new.id_part);

        end if;

        return new;

    elsif (tg_op = 'DELETE') then

        return old;

    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            id_nf = old.id_nf and
            id_nf_parc = old.id_nf_parc;

        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_nf = old.id_nf and
            id_nf_parc = old.id_nf_parc;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
                
                
            if (_op_fnc.tp_op_fnc = 'CRED') OR (_op_fnc.tp_op_fnc = 'BLT') then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, id_nf, id_nf_parc)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _nf.id_part_emt, cast(_nf.num as varchar), new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', new.id_nf, new.id_nf_parc);
                     
            elsif (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
                _id_ch := nextval('sq_ch');
                
                insert into tb_ch
                    (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                     dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_nf, id_nf_parc, id_cnt_bnc)
                values
                    (new.id_emp, _id_ch, 'E', _nf.id_part_emt, new.emit, new.cpf_cnpj,
                     _nf.dt_op, new.dt_venc, new.vl_parc, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_nf, new.id_nf_parc, new.id_cnt_bnc);
                
                perform fc_sit_ch(new.id_emp, _id_ch, 'P', 'NOTA FISCAL ' || _nf.ser || ' - ' || _nf.num, _nf.dt_op, null);
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            id_vnd = old.id_vnd and
            id_vnd_parc = old.id_vnd_parc;

        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_vnd = old.id_vnd and
            id_vnd_parc = old.id_vnd_parc;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _vnd
        from tb_vnd
        where
            id_emp = new.id_emp and
            id_vnd = new.id_vnd;

        if (_vnd.tp_vnd = 'V') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
                
                
            if (_op_fnc.tp_op_fnc = 'CRED') then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, id_vnd, id_vnd_parc)
                values
                    (new.id_emp, nextval('sq_ct'), 'R', _vnd.id_cli, cast(new.id_vnd as varchar), new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', new.id_vnd, new.id_vnd_parc);
                     
            elsif (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
                _id_ch := nextval('sq_ch');
                
                insert into tb_ch
                    (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                     dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_vnd, id_vnd_parc)
                values
                    (new.id_emp, _id_ch, 'R', _vnd.id_cli, new.emit, new.cpf_cnpj,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_vnd, new.id_vnd_parc);
                
                perform fc_sit_ch(new.id_emp, _id_ch, 'P', 'VENDA ' || new.id_vnd, _vnd.dt_vnd, null);
            end if;
            
        end if;
        
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

ALTER TABLE public.tb_ch
  ALTER COLUMN sit TYPE VARCHAR(5);

ALTER TABLE public.tb_ch_sit
  ALTER COLUMN sit TYPE VARCHAR(3);

create view public.vw_vnd_rota
as
select
    id_emp,
    dt_vnd,
    dia_semana,
    id_rota,
    descr,
    sum(vl_cred) as vl_cred,
    sum(vl_ch) as vl_ch,
    sum(vl_out) as vl_out
from
(
    select 
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        case extract(dow from tb_vnd.dt_vnd)
            when 0 then 'Domingo'
            when 1 then 'Segunda'
            when 2 then 'Tera'
            when 3 then 'Quarta'
            when 4 then 'Quinta'
            when 5 then 'Sexta'
            when 6 then 'Sabado'
        end as dia_semana,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr,
        sum(tb_vnd_parc.vl_parc) as vl_cred,
        0 as vl_ch,
        0 as vl_out
    from tb_vnd
    left outer join tb_part on
        (tb_vnd.id_cli = tb_part.id_part)
    left outer join tb_rota on
        (tb_part.id_rota = tb_rota.id_rota)
    left outer join tb_vnd_parc on
        (tb_vnd.id_emp = tb_vnd_parc.id_emp and
         tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
    join tb_op_fnc on
        (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc)
    where
        tb_vnd.id_emp = tb_vnd_parc.id_emp and
        tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
        tb_op_fnc.tp_op_fnc = 'CRED'
    group by
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr
        
    union all

    select 
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        case extract(dow from tb_vnd.dt_vnd)
            when 0 then 'Domingo'
            when 1 then 'Segunda'
            when 2 then 'Tera'
            when 3 then 'Quarta'
            when 4 then 'Quinta'
            when 5 then 'Sexta'
            when 6 then 'Sabado'
        end as dia_semana,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr,
        0 as vl_cred,
        sum(tb_vnd_parc.vl_parc) as vl_ch,
        0 as vl_out
    from tb_vnd
    left outer join tb_part on
        (tb_vnd.id_cli = tb_part.id_part)
    left outer join tb_rota on
        (tb_part.id_rota = tb_rota.id_rota)
    left outer join tb_vnd_parc on
        (tb_vnd.id_emp = tb_vnd_parc.id_emp and
         tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
    join tb_op_fnc on
        (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc)
    where
        tb_vnd.id_emp = tb_vnd_parc.id_emp and
        tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
        tb_op_fnc.tp_op_fnc in ('CH_VST', 'CH_PRZ')
    group by
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr

    union all

    select 
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        case extract(dow from tb_vnd.dt_vnd)
            when 0 then 'Domingo'
            when 1 then 'Segunda'
            when 2 then 'Tera'
            when 3 then 'Quarta'
            when 4 then 'Quinta'
            when 5 then 'Sexta'
            when 6 then 'Sabado'
        end as dia_semana,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr,
        0 as vl_cred,
        0 as vl_ch,
        sum(tb_vnd_parc.vl_parc) as vl_out
    from tb_vnd
    left outer join tb_part on
        (tb_vnd.id_cli = tb_part.id_part)
    left outer join tb_rota on
        (tb_part.id_rota = tb_rota.id_rota)
    left outer join tb_vnd_parc on
        (tb_vnd.id_emp = tb_vnd_parc.id_emp and
         tb_vnd.id_vnd = tb_vnd_parc.id_vnd)
    join tb_op_fnc on
        (tb_vnd_parc.id_op_fnc = tb_op_fnc.id_op_fnc)
    where
        tb_vnd.id_emp = tb_vnd_parc.id_emp and
        tb_vnd.id_vnd = tb_vnd_parc.id_vnd and
        tb_op_fnc.tp_op_fnc not in ('CRED', 'CH_VST', 'CH_PRZ')
    group by
        tb_vnd.id_emp,
        tb_vnd.dt_vnd,
        tb_part.id_rota,
        tb_vnd.id_vndr,
        tb_rota.descr
) as tb
--where
--    id_emp = :id_emp
--[filter]
group by
    id_emp,
    dt_vnd,
    dia_semana,
    id_rota,
    descr
    
order by
    dt_vnd;
DROP FUNCTION public.fc_sit_ch(_id_emp integer, _id_ch integer, _sit varchar, _obs varchar);

