ALTER TABLE public.tb_ch
  DROP CONSTRAINT fk__ch__part RESTRICT;

CREATE OR REPLACE FUNCTION public.fc_tr_ch_bf (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (old.tp_ch = 'E') then
        delete from tb_mov_bnc
        where
            id_emp = old.id_emp and
            org = 'ch' and
            id_org = old.id_ch;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        if (new.tp_ch = 'E') then
            /*
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr, 'D', new.vl_ch, new.obs, false, 'ch', new.id_ch, new.id_part);
              */  
        end if;
        
        return new;
        
    elsif (tg_op = 'DELETE') then
    
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

ALTER TABLE public.tb_mov_bnc
  ADD COLUMN dt_conc DATE;

ALTER TABLE public.tb_ch
  ADD CONSTRAINT fk__ch__part FOREIGN KEY (id_part)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

CREATE TRIGGER tr_ch_bf
  BEFORE INSERT OR UPDATE OR DELETE 
  ON public.tb_ch FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_ch_bf();

