SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_cast_int (
  _val varchar,
  _null boolean
)
RETURNS integer AS
$body$
begin
    if (coalesce(_val, '') = '') and (_null) then
        return null;
    elsif (coalesce(_val, '') = '') and (not _null) then
        return 0;
    else
        return cast(trim(coalesce(_val, '')) as integer);
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

