SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
    _mov_colab boolean;
    _obs varchar;
begin
    _app_con := fc_app_con();
    
    _mov_colab := false;
    
    if (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
    
        delete from tb_recibo
        where
            id_emp = old.id_emp and
            org like 'BX.' || old.id_bx_ct || '%';
            
        _mov_colab := true;
    end if;
    
    if (tg_op = 'UPDATE') then
        if (old.vl_prox_deb <> new.vl_prox_deb) or (old.vl_prox_cred <> new.vl_prox_cred) then
            _mov_colab := true;
        end if;
    end if;
    
    if (_mov_colab) then
        delete from tb_ct
        where
            id_emp = old.id_emp and
            (org = 'MOV_COLAB.CRED.ACT.' || old.id_bx_ct or
             org = 'MOV_COLAB.DEB.ACT.' || old.id_bx_ct);    
    end if;
    
    _mov_colab := false;

    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        _mov_colab := true;    
    end if;
    
    if (tg_op = 'UPDATE') then
        if (old.vl_prox_deb <> new.vl_prox_deb) or (old.vl_prox_cred <> new.vl_prox_cred) then
            _mov_colab := true;
        end if;
    end if;
    
    if (_mov_colab) then
        if (new.op = 'A') then
            
            select * into _op_fnc
            from tb_op_fnc
            where
                tp_op_fnc = 'DUP'
            order by
                id_op_fnc
            limit 1;
        
            _obs := 'ACERTO N ' || new.num_doc;
                
            if (new.obs is not null) then
                _obs := trim(_obs || ' ' || new.obs);
            end if;
                
            if (coalesce(new.vl_prox_deb, 0) > 0) then
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                     dt_emis, dt_venc, vl_ct, stat, 
                     org, id_op_fnc, vl_quit, vl_rest,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     obs,
                     id_veic)
                values
                    (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, new.id_part, new.num_doc,
                     new.dt_bx, new.dt_bx, new.vl_prox_deb, 'P', 
                     'MOV_COLAB.DEB.ACT.' || new.id_bx_ct, _op_fnc.id_op_fnc, 0, new.vl_prox_deb,
                     new.id_usr_ult_alt, new.dt_hr_ult_alt,
                     _obs,
                     new.id_veic);
            end if;
            
            
            if (coalesce(new.vl_prox_cred, 0) > 0) then
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                     dt_emis, dt_venc, vl_ct, stat, 
                     org, id_op_fnc, vl_quit, vl_rest,
                     id_usr_ult_alt, dt_hr_ult_alt,
                     obs,
                     id_veic)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, new.id_part, new.num_doc,
                     new.dt_bx, new.dt_bx, new.vl_prox_cred, 'P', 
                     'MOV_COLAB.CRED.ACT.' || new.id_bx_ct, _op_fnc.id_op_fnc, 0, new.vl_prox_cred,
                     new.id_usr_ult_alt, new.dt_hr_ult_alt,
                     _obs,
                     new.id_veic);
            end if;
        
        end if;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

