CREATE OR REPLACE FUNCTION public.fc_nf_at_prc (
  _id_emp integer,
  _id_nf integer,
  _alt_prc_vnd boolean
)
RETURNS boolean AS
$body$
declare
    _nf record;
    _nf_item_list refcursor;
    _nf_item record;
    _op varchar;
    _op_inv varchar;
    _nat_op record;
begin
    select * into _nf
    from tb_nf
    where
        id_emp = _id_emp and
        id_nf = _id_nf;
        
        
    if (_nf.tp_emis = '[T]') then
        
        select * into _nat_op
        from tb_nat_op
        where
            id_nat_op = _nf.id_nat_op;
            
            
        open _nf_item_list for 
            select *
            from tb_nf_item
            where
                id_emp = _id_emp and
                id_nf = _id_nf;
        
        fetch _nf_item_list into _nf_item;
        
        while found loop
        
            if (_nf_item.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_CST]%') then
                update tb_item_emp set
                    vl_cst_rep = _nf_item.vl_cst_rep,
                    vl_cst_med = _nf_item.vl_cst_med,
                    dt_ult_cmp = _nf.dt_op,
                    id_usr_ult_alt = _nf_item.id_usr_ult_alt
                where
                    id_emp = _nf_item.id_emp and
                    id_item = _nf_item.id_item;
            end if;
                
            if (_nf_item.at_prc_item and _nat_op.op like '%[NF_REC__AT_PRC_VND]%' and _alt_prc_vnd) then
                update tb_item_emp set
                    vl_out = _nf_item.vl_out_prc,
                    vl_perc_desp_op = _nf_item.vl_perc_desp_op_prc,
                    vl_desp_op = _nf_item.vl_desp_op_prc,
                    vl_perc_luc = _nf_item.vl_perc_luc_prc,
                    vl_luc = _nf_item.vl_luc_prc,
                    vl_prc_vnd = _nf_item.vl_prc_vnd,
                    id_usr_ult_alt = _nf_item.id_usr_ult_alt
                where
                    id_emp = _nf_item.id_emp and
                    id_item = _nf_item.id_item;
            end if;
        
        
            fetch _nf_item_list into _nf_item;
            
        end loop;
            
    end if;
    
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;