ALTER TABLE public.tb_bx_ct__ct
  ADD COLUMN vl_quit NUMERIC(12,4);

ALTER TABLE public.tb_bx_ct__ct
  ADD COLUMN vl_rest NUMERIC(12,4);

ALTER TABLE public.tb_ct
  ADD COLUMN vl_quit NUMERIC(12,4);

ALTER TABLE public.tb_ct
  ADD COLUMN vl_rest NUMERIC(12,4);

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct__ct_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        
        update tb_ct set
            stat = 'Q',
            vl_quit = new.vl_quit,
            vl_rest = new.vl_rest
        where
            id_emp = new.id_emp_ct and
            id_ct = new.id_ct;
            
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        
        update tb_ct set
            stat = 'P',
            vl_quit = 0,
            vl_rest = vl_ct
        where
            id_emp = old.id_emp_ct and
            id_ct = old.id_ct;
            
    end if;
    
    return null;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
begin
    _app_con := fc_app_con();
    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        if (new.vl_rest > 0) then
            select * into _op_fnc
            from tb_op_fnc
            where
                tp_op_fnc = 'DUP'
            order by
                id_op_fnc
            limit 1;
            
            insert into tb_ct
                (id_emp, id_ct, tp_ct, id_part, parc, qtd_parc, 
                 dt_emis, dt_venc,
                 vl_ct, obs, stat, tp_doc, 
                 org, id_op_fnc, 
                 vl_quit, vl_rest)
            values
                (new.id_emp, nextval('sq_ct'), new.tp_bx, new.id_part, 1, 1,
                new.dt_bx, new.dt_bx,
                new.vl_rest, 'RESTANTE BAIXA ' || new.id_bx_ct, 'P', 'DUP',
                'BX.' || new.id_bx_ct, _op_fnc.id_op_fnc,
                0, new.vl_rest);
        end if;
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
    
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct;
            
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org like 'BX.' || old.id_bx_ct || '%';
            
    end if;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
    _descr_part varchar;
    _descr varchar;
    _app_con varchar;    
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct || '.' || old.id_bx_ct_pagto;
        
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc,
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, 
                 id_cnt_bnc, org, id_op_fnc, vl_quit, vl_rest)
            values
                (new.id_emp, nextval('sq_ct'), ifthen(_bx_ct.tp_bx = 'R', 'R', 'P'), _op_fnc.tp_op_fnc, _bx_ct.id_part, new.nr_doc,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                 new.id_cnt_bnc, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_op_fnc, 0, new.vl_pagto);
                     
        end if;
        
        select nome into _descr_part
        from tb_part
        where
            id_part = _bx_ct.id_part;
            
        if (_descr_part is null) then
            _descr_part := '';
        else
            _descr_part := ' ' || _descr_part;
        end if;
        
        _descr := ifthen(_bx_ct.tp_bx = 'R', 'RECEBIMENTO', 'PAGAMENTO');
        
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _bx_ct.dt_bx, new.dt_venc, new.nr_doc, ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, trim(_descr || _descr_part), false,
                 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, _bx_ct.id_bx_ct,
                 _bx_ct.id_part, 'PEND');
        /*
        else
            
            perform fc_gera_mov_fnc(new.id_emp, _bx_ct.id_cx, _bx_ct.id_usr, _bx_ct.dt_bx, cast(current_time as time), trim(_descr || _descr_part),
                ifthen(_bx_ct.tp_bx = 'R', 'C', 'D'), new.vl_pagto, 'BX.' || new.id_bx_ct || '.' || new.id_bx_ct_pagto, new.id_bx_ct, new.id_op_fnc);
                */
        end if;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_ct_bf (
)
RETURNS trigger AS
$body$
declare
    _aux varchar[];
    _qtd integer;
    _contr record;
    _dt_venc date;
    
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    
    _op_fnc record;    
    
    _app_con varchar;
begin
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        if (tg_op = 'INSERT' and new.tp_ct = 'P' and new.tp_doc = 'CH') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr_doc, 'D', new.vl_ct, new.obs, false, 
                 'CT.' || new.id_ct, new.id_ct, new.id_part);
        end if;
        
        --
        -- Gera proxima ct contrato
        --
        if (tg_op = 'UPDATE') then
        
            if (new.tp_ct = 'R' and new.stat = 'Q' and old.stat = 'P' and new.org like 'CONTR.%') then
                _aux := regexp_split_to_array(new.org, '\.');
                
                select count(*) into _qtd
                from tb_ct
                where
                    id_emp = new.id_emp and
                    id_part = new.id_part and
                    tp_ct = 'R' and
                    org = new.org and
                    dt_venc > new.dt_venc and
                    id_ct <> new.id_ct;
                
                if (_qtd = 0) then
                    
                    select * into _contr
                    from tb_part_contr
                    where
                        id_emp = new.id_emp and
                        id_part = new.id_part and
                        id_part_contr = cast(_aux[3] as integer);
                
                    if (found) then
                    
                        _dt_venc := fc_calc_venc(new.dt_venc, _contr.tp_interv, _contr.interv);
                        
                        if (_dt_venc <= _contr.dt_f) then
                            _id_cnt_bnc := null;
        
                            if (_contr.tp_doc = 'BLT') then
                                _id_cnt_bnc_str := fc_get_emp_cnf(new.id_emp, 01002);
                                
                                if (_id_cnt_bnc_str <> '') then
                                    _id_cnt_bnc := cast(_id_cnt_bnc_str as integer);
                                end if;
                            end if;
                            
                            select * into _op_fnc
                            from tb_op_fnc
                            where
                                tp_op_fnc = _contr.doc
                            order by
                                id_op_fnc
                            limit 1;
                        
                        
                            insert into tb_ct
                                (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, dt_emis, dt_venc,
                                 vl_ct, obs, stat, tp_doc, org, id_cnt_bnc, id_op_fnc, vl_quit, vl_rest)
                            values
                                (_contr.id_emp, nextval('sq_ct'), 'R', _contr.id_part, _contr.doc, new.parc + 1, new.parc + 1, new.dt_venc, _dt_venc,
                                 _contr.vl_contr, _contr.obs, 'P', _contr.tp_doc, new.org, _id_cnt_bnc, _op_fnc.id_op_fnc, 0, _contr.vl_contr);
                        end if;
                    end if;
                end if;
            elsif (new.tp_ct = 'R' and new.stat = 'P' and old.stat = 'Q' and new.org like 'CONTR.%') then
                _aux := regexp_split_to_array(new.org, '\.');
                    
                select * into _contr
                from tb_part_contr
                where
                    id_emp = new.id_emp and
                    id_part = new.id_part and
                    id_part_contr = cast(_aux[3] as integer);
                        
                if (found) then
                    _dt_venc := fc_calc_venc(new.dt_venc, _contr.tp_interv, _contr.interv);
                    
                    delete from tb_ct
                    where
                        id_emp = new.id_emp and
                        id_part = new.id_part and
                        tp_ct = 'R' and
                        org = new.org and
                        dt_venc = _dt_venc and
                        stat = 'P' and
                        id_ct <> new.id_ct;
                end if;
            end if;
        end if;
        
        -- return new;
    else
        if (old.tp_ct = 'P') and (_app_con <> 'NEO_UNI') then
            delete from tb_mov_bnc
            where
                org = 'CT.' || old.id_ct and
                id_org = old.id_ct;
        end if;
        
        return old;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    else
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _nf record;
    _id_ch integer;
    _app_con varchar;
begin
    _app_con := fc_app_con();

    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;

        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'NF.' || old.id_nf || '.' || old.id_nf_parc;
        
   end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _nf
        from tb_nf
        where
            id_emp = new.id_emp and
            id_nf = new.id_nf;

        if (_nf.tp_emis = '[T]') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, 
                     id_cnt_bnc, org,
                     obs, id_op_fnc, vl_quit, vl_rest)
                values
                    (new.id_emp, nextval('sq_ct'), 'P', _op_fnc.tp_op_fnc, _nf.id_part_emt, new.nr_doc, new.nr_parc, new.qtd_parc,
                     _nf.dt_op, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt,
                     new.id_cnt_bnc, 'NF.' || new.id_nf || '.' || new.id_nf_parc,
                     'NF ' || _nf.num || ' ' || _op_fnc.descr, new.id_op_fnc, 0, new.vl_parc);
                     
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC') then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _nf.dt_op, new.dt_venc, new.nr_doc, 'D', new.vl_parc, 'NF ' || _nf.num || ' ' || _op_fnc.descr, false,
                     'NF.' || new.id_nf || '.' || new.id_nf_parc, _nf.id_nf,
                     _nf.id_part_emt, 'PEND');
            end if;
            
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_part_contr_af (
)
RETURNS trigger AS
$body$
declare
    _qtd integer;
    _id_cnt_bnc integer;
    _id_cnt_bnc_str varchar;
    _op_fnc record;
begin
    select count(*) into _qtd
    from tb_ct
    where
        id_emp = new.id_emp and
        id_part = new.id_part and
        tp_ct = 'R' and
        org = 'CONTR.' || new.id_part || '.' || new.id_part_contr;
        
    if (_qtd = 0) then
        
        _id_cnt_bnc := null;
        
        if (new.tp_doc = 'BLT') then
            _id_cnt_bnc_str := fc_get_emp_cnf(new.id_emp, 01002);
            if (_id_cnt_bnc_str <> '') then
                _id_cnt_bnc := cast(_id_cnt_bnc_str as integer);
            end if;
        end if;
        
        select * into _op_fnc
        from tb_op_fnc
        where
            tp_op_fnc = _contr.doc
        order by
            id_op_fnc
        limit 1;
        
        
        insert into tb_ct
            (id_emp, id_ct, tp_ct, id_part, nr_doc, parc, qtd_parc, dt_emis, dt_venc,
             vl_ct, obs, stat, tp_doc, org, id_cnt_bnc, id_op_fnc, 
             vl_quit, vl_rest)
        values
            (new.id_emp, nextval('sq_ct'), 'R', new.id_part, new.doc, 1, 1, new.dt_i, fc_calc_venc(new.dt_i, new.tp_interv, new.interv),
             new.vl_contr, new.obs, 'P', new.tp_doc, 'CONTR.' || new.id_part || '.' || new.id_part_contr, _id_cnt_bnc, _op_fnc.id_op_fnc,
             0, new.vl_contr);
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
    _app_con varchar;
begin
    _app_con := fc_app_con();
    
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        
        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (_app_con <> 'NEO_UNI') then
        
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        select * into _vnd
        from tb_vnd
        where
            id_emp = new.id_emp and
            id_vnd = new.id_vnd;

        if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
            _nr_doc := new.nr_doc;
                
            if (_op_fnc.tp_op_fnc = 'DUP') then
                _nr_doc := new.id_vnd || '/' || new.nr_parc;
            end if;
            
            insert into tb_ct
                (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                 dt_emis, dt_venc, vl_ct, stat, 
                 emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                 org, id_op_fnc, vl_quit, vl_rest)
            values
                (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                 _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                 new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
                 'VND.' || new.id_vnd || '.' || new.id_vnd_parc, new.id_op_fnc, 0, new.vl_parc);
        end if;
            
        if (_op_fnc.tp_op_fnc = 'BNC') then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                 org, id_org,
                 id_part, sit_conc)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                 'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd,
                 _vnd.id_cli, 'PEND');
        end if;
    end if;

    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            
        return new;
            
    elsif (tg_op = 'DELETE') then
            
        return old;
            
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;



