CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_af (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _app_con varchar;
begin
    _app_con := fc_app_con();
    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        if (new.vl_rest > 0) then
            select * into _op_fnc
            from tb_op_fnc
            where
                tp_op_fnc = 'DUP'
            order by
                id_op_fnc
            limit 1;
            
            insert into tb_ct
                (id_emp, id_ct, tp_ct, id_part, parc, qtd_parc, 
                 dt_emis, dt_venc,
                 vl_ct, obs, stat, tp_doc, 
                 org, id_op_fnc)
            values
                (new.id_emp, nextval('sq_ct'), new.tp_bx, new.id_part, 1, 1,
                new.dt_bx, new.dt_bx,
                new.vl_rest, 'RESTANTE BAIXA ' || new.id_bx_ct, 'P', 'DUP',
                'BX.' || new.id_bx_ct, _op_fnc.id_op_fnc);
        end if;
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
    
        delete from tb_ct 
        where
            id_emp = old.id_emp and
            org = 'BX.' || old.id_bx_ct;
            
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org like 'BX.' || old.id_bx_ct || '%';
            
    end if;

    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;


