SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_cte_bf (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _gera_num boolean;
begin

    _app_con := fc_app_con();
    
    if (tg_op in ('INSERT', 'UPDATE') ) and (_app_con <> 'NEO_UNI') then
        _gera_num := false;
        
        if (tg_op  = 'INSERT' and new.num is null) then
            _gera_num := true;
        end if;
        
        if (tg_op  = 'UPDATE') then
            if (old.mod <> new.mod and new.mod = '57') or (old.ser <> new.ser) then
                _gera_num := true;
            end if;
        end if;
        
        if (_gera_num) then
            new.num := fc_get_num_cte(new.id_emp, new.ser);
        end if;
    end if;
    
    
    if (tg_op in ('INSERT', 'UPDATE') ) then
        return new;
    else
        return old;
    end if;

end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

