SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_item_bf (
)
RETURNS trigger AS
$body$
declare 
    _item_emp record;
BEGIN
    if (tg_op = 'UPDATE' or tg_op = 'INSERT') then
    
        if (tg_op = 'UPDATE') then
            if (coalesce(old.mov_estq, false) and new.vl_qtd_mov <> old.vl_qtd_mov) then
                perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
            end if;
            
            if (coalesce(new.mov_estq, false) and new.vl_qtd_mov <> old.vl_qtd_mov or coalesce(old.mov_estq, false) <> coalesce(new.mov_estq, false)) then
                perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
            end if;
        end if;
        
        if (coalesce(new.mov_estq, false) and tg_op = 'INSERT') then
            perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
        end if;
        
        select * into _item_emp
        from tb_item_emp
        where
            id_item = new.id_item and
            id_emp = new.id_emp;
                
        new.vl_cst_rep = _item_emp.vl_cst_rep;
        new.vl_cst_med = _item_emp.vl_cst_med;
        
        return new;
    
    elsif (tg_op = 'DELETE') then
        
        if (coalesce(old.mov_estq, false)) then
            perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
        end if;
        
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

