SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_pdc_item_bf (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'INSERT') then
            
        perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', cast(new.vl_qtd as numeric));
        
        return new;
        
    elsif (tg_op = 'DELETE') then
    
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', cast(old.vl_qtd as numeric));
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

ALTER TABLE public.tb_fml_item
  ALTER COLUMN vl_qtd TYPE DOUBLE PRECISION;

ALTER TABLE public.tb_pdc_item
  ALTER COLUMN vl_qtd TYPE DOUBLE PRECISION;

