SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct__ct_af (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (tg_op = 'INSERT') and (_app_con <> 'NEO_UNI') then
        
        update tb_ct set
            stat = case when new.vl_rest = 0 then 'Q' else 'P' end,
            vl_quit = coalesce(vl_quit, 0) + coalesce(new.vl_quit, 0),
            vl_rest = coalesce(new.vl_rest, 0),
            dt_hr_ult_alt = new.dt_hr_ult_alt,
            id_usr_ult_alt = new.id_usr_ult_alt,
            id_est_ult_alt = new.id_est_ult_alt
        where
            id_emp = new.id_emp_ct and
            id_ct = new.id_ct;
            
        if (new.id_plano_ct <> null) then
            update tb_ct set
                id_plano_ct = new.id_plano_ct
            where
                id_emp = new.id_emp_ct and
                id_ct = new.id_ct;
        end if;
            
    elsif (tg_op = 'DELETE') and (_app_con <> 'NEO_UNI') then
        
        update tb_ct set
            stat = 'P',
            vl_quit = coalesce(vl_quit, 0) - coalesce(old.vl_quit, 0),
            vl_rest = coalesce(vl_rest, 0) + coalesce(old.vl_quit, 0) - coalesce(old.vl_acr, 0),
            dt_hr_ult_alt = old.dt_hr_ult_alt,
            id_usr_ult_alt = old.id_usr_ult_alt,
            id_est_ult_alt = old.id_est_ult_alt
        where
            id_emp = old.id_emp_ct and
            id_ct = old.id_ct;
            
    end if;
    
    return null;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

