SET check_function_bodies = FALSE;

CREATE OR REPLACE FUNCTION public.fc_tr_nf_bf (
)
RETURNS trigger AS
$body$
declare
    _app_con varchar;
    _nf_item_list refcursor;
    _nf_item record;
    _op_inv varchar;
BEGIN
    _app_con := fc_app_con();
    
    if (tg_op in ('INSERT', 'UPDATE') ) and (_app_con <> 'NEO_UNI') then
        --if (tg_op  = 'INSERT' and new.tp_emis = '[P]' and new.num is null) then
        if (tg_op  = 'INSERT' and new.tp_emis = '[P]') then
            new.num := fc_get_num_nf(new.id_emp, new.id_mod_nf, new.ser);
        end if;
    
    elsif (tg_op = 'DELETE') then
        
        update tb_ped set id_nf = null
        where
            id_emp = old.id_emp and
            id_nf = old.id_nf;
    
        if (old.tp_op = '[E]') then
            _op_inv := 'S';
        else
            _op_inv := 'E';
        end if;
        
        open _nf_item_list for
            select *
            from tb_nf_item
            where
                id_emp = old.id_emp and
                id_nf = old.id_nf;
    
        fetch _nf_item_list into _nf_item;
        
        
    
        while found loop
            if (_nf_item.mov_estq) then
                perform fc_item_estq(_nf_item.id_item, _nf_item.id_emp, _nf_item.id_dep, _nf_item.id_grd_estq, _op_inv, _nf_item.vl_qtd_mov);
            end if;
            
            fetch _nf_item_list into _nf_item;
        end loop;
        
        close _nf_item_list;
        
        
        if (_app_con <> 'NEO_UNI') then
            delete from tb_mov_fnc
            where
                id_emp = old.id_emp and
                org like 'NF.' || old.id_nf || '%';
        end if;
 
    end if;
    
    
    if (tg_op in ('INSERT', 'UPDATE') ) then
        return new;
    else
        return old;
    end if;
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

SET check_function_bodies = TRUE;

