CREATE SEQUENCE public.sq_item_venc
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

CREATE TABLE public.tb_conv_cond_pagto (
  id_conv INTEGER NOT NULL, 
  id_cond_pagto INTEGER NOT NULL, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  CONSTRAINT pk_conv_cond_pagto PRIMARY KEY(id_conv, id_cond_pagto)
) ;

CREATE TABLE public.tb_conv_cond_pagto_op_fnc (
  id_conv INTEGER NOT NULL, 
  id_cond_pagto INTEGER NOT NULL, 
  id_op_fnc INTEGER NOT NULL, 
  vl_perc_desc NUMERIC(12,4), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  CONSTRAINT pk_conv_cond_pagto_op_fnc PRIMARY KEY(id_conv, id_cond_pagto, id_op_fnc)
) ;

ALTER TABLE public.tb_item_emp
  ADD COLUMN promo BOOLEAN;



ALTER TABLE public.tb_item_emp
  ADD COLUMN vl_prc_vnd_promo NUMERIC(12,4);

update tb_item_emp set 
    promo = false, 
    vl_prc_vnd_promo = 0.00;

CREATE TABLE public.tb_item_venc (
  id_emp INTEGER NOT NULL, 
  id_item_venc INTEGER NOT NULL, 
  id_item INTEGER, 
  dt_venc DATE, 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  CONSTRAINT pk_item_venc PRIMARY KEY(id_emp, id_item_venc)
) ;

ALTER TABLE public.tb_item_venc
  ADD CONSTRAINT fk__item_venc__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE SET NULL
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_venc
  ADD CONSTRAINT fk__item_venc__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_conv_cond_pagto_op_fnc
  ADD CONSTRAINT fk__conv_cond_pagto_op_fnc__conv_cond_pagto FOREIGN KEY (id_conv, id_cond_pagto)
    REFERENCES public.tb_conv_cond_pagto(id_conv, id_cond_pagto)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_conv_cond_pagto_op_fnc
  ADD CONSTRAINT fk__conv_cond_pagto_op_fnc__op_fnc FOREIGN KEY (id_op_fnc)
    REFERENCES public.tb_op_fnc(id_op_fnc)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_conv_cond_pagto
  ADD CONSTRAINT fk__conv_cond_pagto__cond_pagto FOREIGN KEY (id_cond_pagto)
    REFERENCES public.tb_cond_pagto(id_cond_pagto)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_conv_cond_pagto
  ADD CONSTRAINT fk__conv_cond_pagto__conv FOREIGN KEY (id_conv)
    REFERENCES public.tb_conv(id_conv)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;