CREATE TABLE public.tb_vnd_dev (
  id_emp INTEGER NOT NULL, 
  id_vnd INTEGER NOT NULL, 
  id_vnd_dev INTEGER NOT NULL, 
  id_item INTEGER, 
  id_und_med VARCHAR(5), 
  vl_qtd NUMERIC(12,4), 
  vl_prc_unt NUMERIC(12,4), 
  vl_tot NUMERIC(12,4), 
  id_dep INTEGER, 
  id_grd_estq VARCHAR(20), 
  mov_estq BOOLEAN, 
  CONSTRAINT pk_vnd_dev PRIMARY KEY(id_emp, id_vnd, id_vnd_dev)
) ;

ALTER TABLE public.tb_vnd_dev
  ADD CONSTRAINT fk__vnd_dev__dep FOREIGN KEY (id_emp, id_dep)
    REFERENCES public.tb_dep(id_emp, id_dep)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd_dev
  ADD CONSTRAINT fk__vnd_dev__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd_dev
  ADD CONSTRAINT fk__vnd_dev__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd_dev
  ADD CONSTRAINT fk__vnd_dev__und_med FOREIGN KEY (id_und_med)
    REFERENCES public.tb_und_med(id_und_med)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_vnd_dev
  ADD CONSTRAINT fk__vnd_dev__vnd FOREIGN KEY (id_emp, id_vnd)
    REFERENCES public.tb_vnd(id_emp, id_vnd)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;
	
	
	
do $$
begin
    if (not exists(select * 
                   from tb_op_fnc
                   where
                       tp_op_fnc = 'DEV')) then
                       
        insert into tb_op_fnc 
            ("id_op_fnc", "tp_op_fnc", "descr", "op", "pos", "fm_pagto", "cd_nfe_pagto", "cd_nfe_band_cart", "mov_cx", "saldo_cx", "ct_rec", "ct_pag", "gera_ct", "id_part_cart", "vl_comis")
        values 
            (nextval('sq_op_fnc'), 'DEV', 'DEVOLUCAO', 'D', 0, true, '01', null, true, false, false, false, false, null, 0);

    end if;
                       
end $$;