CREATE OR REPLACE FUNCTION public.fc_tr_mov_bnc_af (
)
RETURNS trigger AS
$body$
declare
    _id_op_fnc_str varchar;
    _id_op_fnc integer;
begin
    

    if ((tg_op = 'UPDATE') and (old.op = 'T')) or (tg_op = 'DELETE') then
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'MOV_BNC.' || old.id_mov_bnc;
                
        delete from tb_mov_bnc
        where
            id_emp = old.id_emp and
            org = 'MOV_BNC.' || old.id_mov_bnc;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        if (new.op = 'T') and (new.dst = 'C') and (coalesce(new.id_dst, 0) > 0) then
            
            _id_op_fnc := null;
            _id_op_fnc_str := fc_get_emp_cnf(new.id_emp, 15002);
            
            if (_id_op_fnc_str <> '') then
                _id_op_fnc := cast(_id_op_fnc_str as integer);
            end if;
            
            insert into tb_mov_fnc
                (id_emp, id_mov_fnc, id_cx, id_usr, dt_lanc, hr_lanc, 
                 doc, descr, op, vl_lanc, 
                 org, id_org, id_op_fnc)
            values
                (new.id_emp, nextval('sq_mov_fnc'), new.id_dst, new.id_usr, new.dt_emis, substring(cast(current_time as varchar), 1, 8)::time,
                 new.nr_doc, new.descr, 'C', new.vl_lanc, 'MOV_BNC.' || new.id_mov_bnc, new.id_mov_bnc, _id_op_fnc);
        end if;
        
        if (new.op = 'T') and (new.dst = 'B') and (coalesce(new.id_dst, 0) > 0) then
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc,
                 nr_doc, descr, op, vl_lanc, conc,
                 org, id_org)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_dst, new.dt_emis, new.dt_venc, 
                 new.nr_doc, new.descr, 'C', new.vl_lanc, false, 'MOV_BNC.' || new.id_mov_bnc, new.id_mov_bnc);
        end if;
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;