CREATE OR REPLACE FUNCTION public.fc_init_est (
  _id_est integer,
  _upd_id boolean
)
RETURNS boolean AS
$body$
declare
    _seq_list refcursor;
    _seq record;
    _est record;
    _id_init integer;
    _cmd varchar;
    _tab record;
    _max_id integer;
begin
    select * into _est
    from tb_est
    where
        id_est = _id_est;
        
    open _seq_list for
        select * 
        from pg_class 
        where
            relkind = 'S';
            
    fetch _seq_list into _seq;
    
    perform fc_en_trg(false, false);
    
    while found loop
        select * into _tab
        from vw_tab_uni
        where
            tablename = replace(_seq.relname, 'sq_', 'tb_');
    
        if (_tab.op = 'S') then
        
            _id_init := _est.seq_inc + _est.id_est;
            
            raise notice '% %', _seq.relname, _id_init;
            
            execute 
                ' select max(' || replace(_seq.relname, 'sq_', 'id_') || ') ' ||
                ' from ' || _tab.tablename ||
                ' where mod(' || replace(_seq.relname, 'sq_', 'id_') || ',' || _est.seq_inc || ') = ' || _est.id_est  
                into _max_id;
            
            if (_max_id is null) then
                _max_id := _id_init;
            else
                _max_id := _max_id + _est.seq_inc;
            end if;
            
            
            _cmd := 'alter sequence ' || _seq.relname || ' increment by ' || _est.seq_inc || ' restart with ' || _max_id;
            
            raise notice '%', _cmd;
            
            execute _cmd;
            
            if (_upd_id is null) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = ' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' / ' || 
                    _est.seq_inc;
                
                raise notice '%', _cmd;
                
                execute _cmd;
            elsif (_upd_id) then
                _cmd := 'update ' || quote_ident(replace(_seq.relname, 'sq_', 'tb_')) || ' set ' ||
                    quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' = (' || quote_ident(replace(_seq.relname, 'sq_', 'id_')) || ' * ' || 
                    _est.seq_inc || ') + ' || _est.id_est;
                
                raise notice '%', _cmd;
                
                execute _cmd;
            end if;
        elsif found then
            
            execute ' select max(' || replace(_seq.relname, 'sq_', 'id_') || ') ' || ' from ' || _tab.tablename into _max_id;
            
            _cmd := 'alter sequence ' || _seq.relname || ' increment by 1 restart with ' || coalesce(_max_id, '1');

            raise notice '%', _cmd;
            
            execute _cmd;
        
        end if;
    
        fetch _seq_list into _seq;
    end loop;
    
    perform fc_en_trg(true, false);
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;