CREATE SEQUENCE public.sq_carreg
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_carreg RESTART WITH 5;

ALTER TABLE public.tb_ped_item
  DROP CONSTRAINT fk__ped_item__grd_estq RESTRICT;

ALTER TABLE public.tb_ped_item
  DROP CONSTRAINT fk__ped_item__dep RESTRICT;

CREATE OR REPLACE FUNCTION public.fc_tr_ped_item_bf (
)
RETURNS trigger AS
$body$
DECLARE
    _item record;
    _exc_estq boolean;
    _inc_estq boolean;
BEGIN
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    else
        return old;
    end if;


    /*
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        select * into _item
        from tb_item
        where
            id_item = new.id_item;
    else
        select * into _item
        from tb_item
        where
            id_item = old.id_item;
    end if;
    
    _exc_estq := false;
    _inc_estq := false;
    
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and 
        (coalesce(old.id_dep, -1) <> coalesce(old.id_dep_dst, -1)) and
        (old.vl_qtd_mov <> new.vl_qtd_mov) then
        
        _exc_estq := true;
    
    end if;
    
    if ( (tg_op = 'INSERT') and (coalesce(new.id_dep, -1) <> coalesce(new.id_dep_dst, -1)) ) or
        ( (tg_op = 'UPDATE') and (coalesce(new.id_dep, -1) <> coalesce(new.id_dep_dst, -1)) and (old.vl_qtd_mov <> new.vl_qtd_mov) ) then
        
        _inc_estq := true;
        
    end if;
        
    
    
    if (_exc_estq) then
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep, old.id_grd_estq, 'E', old.vl_qtd_mov);
        perform fc_item_estq(old.id_item, old.id_emp, old.id_dep_dst, old.id_grd_estq, 'S', old.vl_qtd_mov);
    end if;
    
    if (_inc_estq) then
        perform fc_item_estq(new.id_item, new.id_emp, new.id_dep, new.id_grd_estq, 'S', new.vl_qtd_mov);
        perform fc_item_estq(new.id_item, new.id_emp, new.id_dep_dst, new.id_grd_estq, 'E', new.vl_qtd_mov);
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        return new;
    else
        return old;
    end if;
    
    */
END;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_carreg (
  id_emp INTEGER NOT NULL, 
  id_carreg INTEGER NOT NULL, 
  dt_i DATE, 
  dt_f DATE, 
  id_vndr INTEGER, 
  id_dep_org INTEGER, 
  id_dep_dst INTEGER, 
  placa VARCHAR(10), 
  sit VARCHAR(1)
) WITHOUT OIDS;

CREATE TABLE public.tb_carreg_ped (
  id_emp INTEGER NOT NULL, 
  id_carreg INTEGER NOT NULL, 
  id_ped INTEGER NOT NULL, 
  tp VARCHAR(10)
) WITHOUT OIDS;

ALTER TABLE public.tb_part
  ALTER COLUMN fax TYPE VARCHAR(20);

ALTER TABLE public.tb_carreg_ped
  ADD CONSTRAINT pk_carreg_ped 
    PRIMARY KEY (id_emp, id_carreg, id_ped);

ALTER TABLE public.tb_carreg
  ADD CONSTRAINT pk_carreg 
    PRIMARY KEY (id_emp, id_carreg);

ALTER TABLE public.tb_ped_item
  ADD CONSTRAINT fk__ped_item__grd_estq FOREIGN KEY (id_grd_estq)
    REFERENCES public.tb_grd_estq(id_grd_estq)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_ped_item
  ADD CONSTRAINT fk__ped_item__dep FOREIGN KEY (id_emp, id_dep)
    REFERENCES public.tb_dep(id_emp, id_dep)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_carreg_ped
  ADD CONSTRAINT fk__carreg_ped__ped FOREIGN KEY (id_emp, id_ped)
    REFERENCES public.tb_ped(id_emp, id_ped)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_carreg_ped
  ADD CONSTRAINT fk__carreg_ped__carreg FOREIGN KEY (id_emp, id_carreg)
    REFERENCES public.tb_carreg(id_emp, id_carreg)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_carreg
  ADD CONSTRAINT fk__carreg__vndr FOREIGN KEY (id_vndr)
    REFERENCES public.tb_part(id_part)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_carreg
  ADD CONSTRAINT fk__carreg__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_carreg
  ADD CONSTRAINT fk__carreg__dep_org FOREIGN KEY (id_emp, id_dep_org)
    REFERENCES public.tb_dep(id_emp, id_dep)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_carreg
  ADD CONSTRAINT fk__carreg__dep_dst FOREIGN KEY (id_emp, id_dep_dst)
    REFERENCES public.tb_dep(id_emp, id_dep)
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

