CREATE OR REPLACE FUNCTION public.fc_log_tab (
  _tab name
)
RETURNS boolean AS
$body$
declare
    _cmd varchar;
begin
    --tb_emp_cnf
    
    /*
    if (_tab in ('tb_bairro', 'tb_blt', 'tb_blt_ret', 'tb_bnc', 'tb_bnc_blt', 'tb_bx_ct', 
        'tb_cfop', 'tb_ch', 'tb_cnae', 'tb_cnt_bnc', 'tb_cond_pagto', 'tb_conv',
        'tb_ct', 'tb_cx', 'tb_dep', 'tb_emis_blt', 'tb_grd_estq', 
        'tb_grp_cfop', 'tb_grp_item', 'tb_grp_trib', 'tb_grp_usr', 'tb_item',
        'tb_logr', 'tb_marca', 'tb_mnt_estq', 'tb_mod_frete', 'tb_mod_nf', 
        'tb_mov_cx', 'tb_mov_fnc', 'tb_mtv_dev_ch', 'tb_munic', 'tb_nat_op', 
        'tb_ncm', 'tb_nf', 'tb_nfe_dest', 'tb_obj_os', 'tb_op_fnc', 'tb_org_icms', 
        'tb_os', 'tb_part', 'tb_ped', 'tb_prio_os', 'tb_prod_anp', 'tb_reg_trib',
        'tb_rel', 'tb_script', 'tb_serv', 'tb_sis_grid', 'tb_sis_valid', 'tb_tp_item',
        'tb_trib_cofins', 'tb_trib_icms', 'tb_trib_ipi', 'tb_trib_pis', 'tb_uf',
        'tb_und_med', 'tb_usr', 'tb_vnd')
    ) */
    if (_tab not in ('tb_log', 'tb_log_con', 'tb_item_estq')) then
    
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;

        _cmd := 'create trigger ' || replace(_tab, 'tb_', 'tr_') || '_log ';
        
        if (_tab = 'tb_est') then
            _cmd := _cmd || ' after insert or delete ';
        else
            _cmd := _cmd || ' after insert or update or delete ';
        end if;
        
        _cmd := _cmd || ' on ' || _tab || ' for each row ' ||
            'execute procedure fc_tr_log()';
        
        execute _cmd;
            
        return true;
        
    else 
        -- raise notice '%', replace(_tab, 'tb_', 'tr_');
        
        execute 'drop trigger if exists ' || replace(_tab, 'tb_', 'tr_') || '_log on ' || _tab;
        
        return false;
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_log (
)
RETURNS trigger AS
$body$
declare
    _pk varchar[];
    _val varchar[];
    _col_list varchar[];
    _val_list varchar[];
    _id_est integer;
    _i integer;
    _idx integer;
    _count integer;
    _aux varchar;
begin
    select
        array(
            select 
                cast(c.column_name as varchar)
            from information_schema.table_constraints tc
            join information_schema.constraint_column_usage as ccu using 
                (constraint_schema, constraint_name)
            join information_schema.columns as c on 
                (c.table_schema = tc.constraint_schema and 
                 tc.table_name = c.table_name and 
                 ccu.column_name = c.column_name)
            where 
                constraint_type = 'PRIMARY KEY' and
                tc.table_name = tg_table_name
            )
    into _pk;
    
    select
        array(
            select 
                pg_attribute.attname
            from pg_attribute 
            join pg_class on 
                (pg_attribute.attrelid = pg_class.oid) 
            where 
                pg_attribute.attname not in ('oid', 'tableoid', 'cmax', 'xmax', 'cmin', 'xmin', 'ctid') and 
                pg_class.relname = tg_table_name
            order by
                pg_attribute.attnum
        )
    into _col_list;
    
    
    _id_est := fc_id_est_con();
    
    _count := array_upper(_pk, 1);
    
    for _i in 1.._count loop

        if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using new;
        else
            execute 'select ($1).' || _pk[_i] || '::text' into _aux using old;
        end if;
        
        _val[_i] := _aux;
    end loop;
    
    
    insert into tb_log
        (id_log, org, op, col_pk, val_pk, id_est, dt_hr)
    values
        (nextval('sq_log'), tg_table_name, substring(tg_op, 1, 1), _pk, _val, _id_est, CURRENT_TIMESTAMP);
    
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_vnd_parc_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _vnd record;
    _id_ch integer;
    _nr_doc varchar;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ct
        where 
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        
        delete from tb_mov_bnc
        where 
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc;
        
        delete from tb_mov_fnc
        where
            id_emp = old.id_emp and
            org = 'VND.' || old.id_vnd || '.' || old.id_vnd_parc and
            id_org = old.id_vnd;
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _vnd
        from tb_vnd
        where
            id_emp = new.id_emp and
            id_vnd = new.id_vnd;

        if (_vnd.tp_vnd = 'V') then
        
            select * into _op_fnc
            from tb_op_fnc
            where
                id_op_fnc = new.id_op_fnc;
                
            if (_op_fnc.tp_op_fnc in ('DUP', 'CH', 'BLT')) then
                
                _nr_doc := new.nr_doc;
                
                if (_op_fnc.tp_op_fnc = 'DUP') then
                    _nr_doc := new.id_vnd || '/' || new.nr_parc;
                end if;
            
                insert into tb_ct
                    (id_emp, id_ct, tp_ct, tp_doc, id_part, nr_doc, parc, qtd_parc, 
                     dt_emis, dt_venc, vl_ct, stat, 
                     emit, cpf_cnpj, id_bnc, ag, cnt, id_cnt_bnc,
                     org)
                values
                    (new.id_emp, nextval('sq_ct'), 'R', _op_fnc.tp_op_fnc, _vnd.id_cli, _nr_doc, new.nr_parc, new.qtd_parc,
                     _vnd.dt_vnd, new.dt_venc, new.vl_parc, 'P', 
                     new.emit, new.cpf_cnpj, new.id_bnc, new.ag, new.cnt, new.id_cnt_bnc,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc);
            end if;
            
            
            if (_op_fnc.tp_op_fnc = 'BNC') then
                insert into tb_mov_bnc
                    (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, 
                     org, id_org,
                     id_part, sit_conc)
                values
                    (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, _vnd.dt_vnd, new.dt_venc, new.nr_doc, 'C', new.vl_parc, 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr, false,
                     'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd,
                     _vnd.id_cli, 'PEND');
            else
                perform fc_gera_mov_fnc(new.id_emp, _vnd.id_cx, _vnd.id_usr, _vnd.dt_vnd, cast(current_time as time), 'VENDA '  || _vnd.nome || ' ' || _op_fnc.descr,
                    'C', new.vl_parc, 'VND.' || new.id_vnd || '.' || new.id_vnd_parc, _vnd.id_vnd);
            end if;
        end if;
        
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then
        
        return new;
        
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

