CREATE OR REPLACE FUNCTION public.fc_sit_ch (
  _id_emp integer,
  _id_ch integer,
  _sit varchar,
  _obs varchar,
  _dt date,
  _id_cnt_bnc integer
)
RETURNS boolean AS
$body$
declare
    _id_ch_sit integer;
begin
    select coalesce(max(id_ch_sit), 0) + 1 into _id_ch_sit
    from tb_ch_sit
    where
        id_emp = _id_emp and
        id_ch = _id_ch;
    
    insert into tb_ch_sit 
        (id_emp, id_ch, id_ch_sit, dt_sit, sit, obs)
    values
        (_id_emp, _id_ch, _id_ch_sit, current_date, _sit, _obs);
        
    if (_id_cnt_bnc is not null) then
        update tb_ch set
            id_cnt_bnc = _id_cnt_bnc
        where
            id_emp = _id_emp and
            id_ch = _id_ch;
    end if;
    
    update tb_ch set
        dt_sit = _dt,
        sit = _sit
    where
        id_emp = _id_emp and
        id_ch = _id_ch;
        
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_bx_ct_pagto_bf (
)
RETURNS trigger AS
$body$
declare
    _op_fnc record;
    _bx_ct record;
    _id_ch integer;
begin
    if (tg_op = 'DELETE' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        delete from tb_ch
        where 
            id_emp = old.id_emp and
            id_bx_ct = old.id_bx_ct and
            id_bx_ct_pagto = old.id_bx_ct_pagto;
    end if;
    
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') and (fc_id_est_con() is null) then
        
        select * into _bx_ct
        from tb_bx_ct
        where
            id_emp = new.id_emp and
            id_bx_ct = new.id_bx_ct;
            
        select * into _op_fnc
        from tb_op_fnc
        where
            id_op_fnc = new.id_op_fnc;
            
        if (_op_fnc.tp_op_fnc = 'CH_VST') or (_op_fnc.tp_op_fnc = 'CH_PRZ') then
                
            _id_ch := nextval('sq_ch');
                
            insert into tb_ch
                (id_emp, id_ch, tp_ch, id_part, emit, cpf_cnpj,
                 dt_emis, dt_venc, vl_ch, id_bnc, ag, cnt, nr, sit, id_bx_ct, id_bx_ct_pagto, id_cnt_bnc)
            values
                (new.id_emp, _id_ch, ifthen(_bx_ct.tp_bx = 'R', 'R', 'E'), _bx_ct.id_part, new.emit, new.cpf_cnpj,
                 _bx_ct.dt_bx, new.dt_venc, new.vl_pagto, new.id_bnc, new.ag, new.cnt, new.nr_doc, 'P', new.id_bx_ct, new.id_bx_ct_pagto, new.id_cnt_bnc);
                
            if (_bx_ct.tp_bx = 'R') then
                perform fc_sit_ch(new.id_emp, _id_ch, 'P', 'RECEBIMNTO DE DUPLICATA ' || _bx_ct.id_bx_ct, _bx_ct.dt_bx, null);
            else
                perform fc_sit_ch(new.id_emp, _id_ch, 'P', 'PAGAMENTO DE DUPLICATA ' || _bx_ct.id_bx_ct, _bx_ct.dt_bx, null);
            end if;
        end if;
            
    end if;
    
    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        return new;
    
    elsif (tg_op = 'DELETE') then
        
        return old;
        
    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE OR REPLACE FUNCTION public.fc_tr_ch_bf (
)
RETURNS trigger AS
$body$
begin
    if (tg_op = 'DELETE' and old.tp_ch = 'E') then
        delete from tb_mov_bnc
        where
            id_emp = old.id_emp and
            org = 'ch' and
            id_org = old.id_ch;
    end if;

    if (tg_op = 'INSERT' or tg_op = 'UPDATE') then

        if (new.tp_ch = 'E' and tg_op = 'INSERT') then

            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_emis, new.dt_venc, new.nr, 'D', new.vl_ch, new.obs, false, 'ch', new.id_ch, new.id_part);

        elseif (tg_op = 'UPDATE' and (old.sit = 'P' or old.sit = 'D') and new.sit = 'DEP') then
            
            insert into tb_mov_bnc
                (id_emp, id_mov_bnc, id_cnt_bnc, dt_emis, dt_venc, nr_doc, op, vl_lanc, descr, conc, org, id_org, id_part)
            values
                (new.id_emp, nextval('sq_mov_bnc'), new.id_cnt_bnc, new.dt_sit, new.dt_sit, new.nr, 'C', new.vl_ch, 'DEPOSITO', false, 'ch', new.id_ch, new.id_part);

        elseif (tg_op = 'UPDATE' and new.sit = 'P') then
            delete from tb_mov_bnc
            where
                id_emp = new.id_emp and
                org = 'ch' and
                id_org = new.id_ch;
        end if;

        return new;

    elsif (tg_op = 'DELETE') then

        return old;

    end if;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;
