CREATE OR REPLACE FUNCTION public.fc_tr_item_af (
)
RETURNS trigger AS
$body$
declare
    _grd_estq record;
    _grd_estq_list refcursor;
begin
    if (tg_op = 'INSERT') then
    
        open _grd_estq_list for
            select 
                tb_dep.id_emp,
                tb_dep.id_dep,
                tb_grd_estq.id_grd_estq
            from tb_dep, tb_grd_estq;
        
        fetch _grd_estq_list into _grd_estq;
        
        while found loop
            insert into tb_item_estq
                (id_item, id_emp, id_dep, id_grd_estq, vl_estq)
            values
                (new.id_item, _grd_estq.id_emp, _grd_estq.id_dep, _grd_estq.id_grd_estq, 0);
        
            fetch _grd_estq_list into _grd_estq;
        end loop;
    end if;
    
    return null;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE TRIGGER tr_item_af
  AFTER INSERT OR UPDATE OR DELETE 
  ON public.tb_item FOR EACH ROW 
  EXECUTE PROCEDURE public.fc_tr_item_af();

