CREATE SEQUENCE public.sq_cmp_cst
  INCREMENT 1 MINVALUE 1
  MAXVALUE 9223372036854775807 START 1
  CACHE 1;

ALTER SEQUENCE public.sq_cmp_cst RESTART WITH 6;

CREATE OR REPLACE FUNCTION public.fc_item_cmp_cst (
  _id_item integer,
  _id_emp integer,
  _id_cmp_cst integer,
  _vl_cst numeric,
  _vl_perc numeric,
  _vl_cst_brt numeric
)
RETURNS boolean AS
$body$
declare
    _rec record;
begin
    if (coalesce(_vl_perc, 0) = 0 and coalesce(_vl_cst, 0) <> 0 and coalesce(_vl_cst_brt, 0) <> 0) then
        _vl_perc := _vl_cst * 100 / _vl_cst_brt;
    end if;
    
    
    select * into _rec
    from tb_item_cmp_cst
    where
        id_item = _id_item and
        id_emp = _id_emp and
        id_cmp_cst = _id_cmp_cst;
    
    if (found) then
    
        update tb_item_cmp_cst set
            vl_cst = coalesce(_vl_cst, 0),
            vl_perc = coalesce(_vl_perc, 0)
        where
            id_item = _id_item and
            id_emp = _id_emp and
            id_cmp_cst = _id_cmp_cst;
    
    else

        insert into tb_item_cmp_cst
            (id_item, id_emp, id_cmp_cst, vl_perc, vl_cst)
        values
            (_id_item, _id_emp, _id_cmp_cst, coalesce(_vl_perc, 0), coalesce(_vl_cst, 0));
    
    end if;
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_nf_item_cmp_cst (
  _id_emp integer,
  _id_nf integer,
  _id_nf_item integer,
  _id_cmp_cst integer,
  _vl_cst numeric,
  _vl_perc numeric,
  _vl_cst_brt numeric
)
RETURNS boolean AS
$body$
declare
    _rec record;
begin
    if (coalesce(_vl_perc, 0) = 0 and coalesce(_vl_cst, 0) <> 0 and coalesce(_vl_cst_brt, 0) <> 0) then
        _vl_perc := _vl_cst * 100 / _vl_cst_brt;
    end if;
    
    
    select * into _rec
    from tb_nf_item_cmp_cst
    where
        id_emp = _id_emp and
        id_nf = _id_nf and
        id_nf_item = _id_nf_item and
        id_cmp_cst = _id_cmp_cst;
    
    if (found) then
    
        update tb_nf_item_cmp_cst set
            vl_cst = coalesce(_vl_cst, 0),
            vl_perc = coalesce(_vl_perc, 0)
        where
            id_emp = _id_emp and
            id_nf = _id_nf and
            id_nf_item = _id_nf_item and
            id_cmp_cst = _id_cmp_cst;
    
    else

        insert into tb_nf_item_cmp_cst
            (id_emp, id_nf, id_nf_item, id_cmp_cst, vl_perc, vl_cst)
        values
            (_id_emp, _id_nf, _id_nf_item, _id_cmp_cst, coalesce(_vl_perc, 0), coalesce(_vl_cst, 0));
    
    end if;
    
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER;

CREATE OR REPLACE FUNCTION public.fc_restart_sequence (
)
RETURNS boolean AS
$body$
declare
    v_cur refcursor;
    v_rec record;
    v_op varchar;
    v_id_max integer;
    v_aux integer;
    v_sql varchar;
begin

    select count(*) into v_aux
    from tb_est;
    
    if (v_aux > 1) then
        raise exception 'Existe mais de uma estação cadastrada, execute a funcao de iniciar estação';
        return false;
    end if;

 
    open v_cur for
        select relname, substring(relname, 4, length(relname)) as "entidade"
        from pg_class
        where 
            relname like 'sq_%';
     
    fetch v_cur into v_rec;
     
    while found loop
     
        select count(*) into v_aux
        from pg_class
        where
            relname = 'tb_' || v_rec."entidade";
         
        if (v_aux > 0) then
            v_sql := 'select max("id_' || v_rec."entidade" || '")::integer ' ||
                'from "tb_' || v_rec."entidade" || '"';
            if (v_rec.entidade = 'tb_cmp_cst') then
                v_sql := v_sql + ' where id_cmp_cst < 1000';
            end if;
                
                
            execute v_sql into v_id_max;
         
            raise notice '[% %]   ', v_rec."relname", v_id_max;
             
            if (v_id_max is not null) then
                execute 'alter sequence "' || v_rec."relname" || '" restart with ' || v_id_max + 1;
            else
                execute 'alter sequence "' || v_rec."relname" || '" restart with 1';
            end if;
        end if;
         
        fetch v_cur into v_rec;
    end loop;
     
    return true;
end;
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;

CREATE TABLE public.tb_cmp_cst (
  id_cmp_cst INTEGER NOT NULL, 
  descr VARCHAR(150), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR(100), 
  comp_ult_alt VARCHAR(100), 
  op VARCHAR(1), 
  CONSTRAINT pk_cmp_cst PRIMARY KEY(id_cmp_cst)
) ;

CREATE TABLE public.tb_item_cmp_cst (
  id_item INTEGER NOT NULL, 
  id_emp INTEGER NOT NULL, 
  id_cmp_cst INTEGER NOT NULL, 
  vl_perc NUMERIC(12,4), 
  vl_cst NUMERIC(12,4), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR(100), 
  comp_ult_alt VARCHAR(100), 
  CONSTRAINT pk_item_cmp_cst PRIMARY KEY(id_item, id_emp, id_cmp_cst)
) ;

CREATE TABLE public.tb_nf_item_cmp_cst (
  id_emp INTEGER NOT NULL, 
  id_nf INTEGER NOT NULL, 
  id_nf_item INTEGER NOT NULL, 
  id_cmp_cst INTEGER NOT NULL, 
  vl_perc NUMERIC(12,4), 
  vl_cst NUMERIC(12,4), 
  id_usr_ult_alt INTEGER, 
  dt_hr_ult_alt TIMESTAMP WITHOUT TIME ZONE, 
  id_usr_cad INTEGER, 
  dt_hr_cad TIMESTAMP WITHOUT TIME ZONE, 
  id_est_ult_alt INTEGER, 
  id_est_cad INTEGER, 
  comp_cad VARCHAR(100), 
  comp_ult_alt VARCHAR(100), 
  CONSTRAINT pk_nf_item_cmp_cst PRIMARY KEY(id_emp, id_nf, id_nf_item, id_cmp_cst)
) ;

ALTER TABLE public.tb_nf_item_cmp_cst
  ADD CONSTRAINT fk__nf_item_cmp_cst__cmp_cst FOREIGN KEY (id_cmp_cst)
    REFERENCES public.tb_cmp_cst(id_cmp_cst)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_nf_item_cmp_cst
  ADD CONSTRAINT fk__nf_item_cmp_cst__nf_item FOREIGN KEY (id_emp, id_nf, id_nf_item)
    REFERENCES public.tb_nf_item(id_emp, id_nf, id_nf_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_cmp_cst
  ADD CONSTRAINT fk__item_cmp_cst__cmp_cst FOREIGN KEY (id_cmp_cst)
    REFERENCES public.tb_cmp_cst(id_cmp_cst)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_cmp_cst
  ADD CONSTRAINT fk__item_cmp_cst__emp FOREIGN KEY (id_emp)
    REFERENCES public.tb_part(id_part)
    MATCH FULL
    ON DELETE RESTRICT
    ON UPDATE CASCADE
    NOT DEFERRABLE;

ALTER TABLE public.tb_item_cmp_cst
  ADD CONSTRAINT fk__item_cmp_cst__item FOREIGN KEY (id_item)
    REFERENCES public.tb_item(id_item)
    MATCH FULL
    ON DELETE CASCADE
    ON UPDATE CASCADE
    NOT DEFERRABLE;
