CREATE OR REPLACE FUNCTION public.fc_add_col (
  _tbl pg_catalog.regclass,
  _col text,
  _type pg_catalog.regtype
)
RETURNS boolean AS
$body$
begin
    if exists (
        select 1
        from pg_attribute
        where attrelid = _tbl and
              attname = _col and
              not attisdropped) then
          
        return false;

    else
        execute 'alter table ' || _tbl || ' add column ' || quote_ident(_col) || ' ' || _type;
        return true;
    end if;
end
$body$
LANGUAGE 'plpgsql'
VOLATILE
CALLED ON NULL INPUT
SECURITY INVOKER
COST 100;